/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server.util;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jbpm.workbench.pr.backend.server.util.VariableHelper;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.kie.server.api.model.instance.VariableInstance;

public class DefaultVariableProcessor
implements VariableHelper.VariableProcessor {
    @Override
    public void process(long processInstanceId, String varName, String varType, List<VariableInstance> variables, Consumer<ProcessVariableSummary> consumer) {
        Optional<VariableInstance> optional = variables.stream().filter(variableInstance -> variableInstance.getVariableName().equals(varName)).findAny();
        if (optional.isPresent()) {
            VariableInstance variable = optional.get();
            consumer.accept(new ProcessVariableSummary(variable.getVariableName(), variable.getVariableName(), variable.getProcessInstanceId().longValue(), variable.getOldValue(), variable.getValue(), variable.getDate().getTime(), varType));
            variables.remove(variable);
        } else {
            consumer.accept(new ProcessVariableSummary(varName, "", processInstanceId, "", "", new Date().getTime(), varType));
        }
    }

    @Override
    public String getSupportedType() {
        return null;
    }
}

