/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.globals;

import elemental2.promise.Promise;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ItemObjectModelFactory;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.NamedObjectItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.globals.DeploymentsGlobalsView;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.modal.doublevalue.AddDoubleValueModal;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.uberfire.client.promise.Promises;

@Dependent
public class DeploymentsGlobalsPresenter
extends Section<DeploymentDescriptorModel> {
    private final DeploymentsGlobalsView view;
    private final GlobalsListPresenter globalPresenters;
    private final AddDoubleValueModal addGlobalModal;
    private final ItemObjectModelFactory itemObjectModelFactory;

    @Inject
    public DeploymentsGlobalsPresenter(Event<SettingsSectionChange<DeploymentDescriptorModel>> settingsSectionChangeEvent, MenuItem<DeploymentDescriptorModel> menuItem, Promises promises, DeploymentsGlobalsView view, GlobalsListPresenter globalPresenters, AddDoubleValueModal addGlobalModal, ItemObjectModelFactory itemObjectModelFactory) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.globalPresenters = globalPresenters;
        this.addGlobalModal = addGlobalModal;
        this.itemObjectModelFactory = itemObjectModelFactory;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Promise<Void> setup(DeploymentDescriptorModel model) {
        this.addGlobalModal.setup("AddGlobal", "Name", "Value");
        if (model.getGlobals() == null) {
            model.setGlobals(new ArrayList());
        }
        this.globalPresenters.setup(this.view.getGlobalsTable(), model.getGlobals(), (global, presenter) -> presenter.setup((ItemObjectModel)global, this));
        return this.promises.resolve();
    }

    public void openNewGlobalModal() {
        this.addGlobalModal.show(this::addGlobal);
    }

    void addGlobal(String name, String value) {
        this.globalPresenters.add(this.itemObjectModelFactory.newItemObjectModel(name, value));
        this.fireChangeEvent();
    }

    public SectionView<?> getView() {
        return this.view;
    }

    public int currentHashCode() {
        return this.globalPresenters.getObjectsList().hashCode();
    }

    @Dependent
    public static class GlobalsListPresenter
    extends ListPresenter<ItemObjectModel, NamedObjectItemPresenter> {
        @Inject
        public GlobalsListPresenter(ManagedInstance<NamedObjectItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }
}

