/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLTableSectionElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jboss.errai.ui.shared.api.annotations.TranslationKey;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;

@Templated
public class DeploymentsSectionView
implements DeploymentsSectionPresenter.View {
    @Inject
    private TranslationService translationService;
    @TranslationKey(defaultValue="")
    public static final String DeploymentsXmlConcurrentUpdate = "DeploymentsXmlConcurrentUpdate";
    @Inject
    @DataField(value="runtime-strategies")
    private HTMLDivElement runtimeStrategies;
    @Inject
    @DataField(value="persistence-unit-name")
    private HTMLInputElement persistenceUnitName;
    @Inject
    @DataField(value="persistence-modes")
    private HTMLDivElement persistenceModes;
    @Inject
    @DataField(value="audit-persistence-unit-name")
    private HTMLInputElement auditPersistenceUnitName;
    @Inject
    @DataField(value="audit-modes")
    private HTMLDivElement auditModes;
    @Inject
    @Named(value="tbody")
    @DataField(value="marshalling-strategies")
    private HTMLTableSectionElement marshallingStrategiesTable;
    @Inject
    @DataField(value="add-marshalling-strategy-button")
    private HTMLButtonElement addMarshallingStrategyButton;
    @Inject
    @Named(value="tbody")
    @DataField(value="event-listeners")
    private HTMLTableSectionElement eventListenersTable;
    @Inject
    @DataField(value="add-event-listener-button")
    private HTMLButtonElement addEventListenerButton;
    @Inject
    @Named(value="tbody")
    @DataField(value="globals")
    private HTMLTableSectionElement globalsTable;
    @Inject
    @DataField(value="add-global-button")
    private HTMLButtonElement addGlobalButton;
    @Inject
    @Named(value="tbody")
    @DataField(value="required-roles")
    private HTMLTableSectionElement requiredRolesTable;
    @Inject
    @DataField(value="add-required-role-button")
    private HTMLButtonElement addRequiredRoleButton;
    @Inject
    @Named(value="h3")
    @DataField(value="title")
    private HTMLHeadingElement title;
    private DeploymentsSectionPresenter presenter;

    public void init(DeploymentsSectionPresenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"persistence-unit-name"})
    public void onPersistenceUnitNameChanged(ChangeEvent ignore) {
        this.presenter.setPersistenceUnitName(this.persistenceUnitName.value);
    }

    @EventHandler(value={"audit-persistence-unit-name"})
    public void onAuditPersistenceUnitNameChanged(ChangeEvent ignore) {
        this.presenter.setAuditPersistenceUnitName(this.auditPersistenceUnitName.value);
    }

    @EventHandler(value={"add-marshalling-strategy-button"})
    public void onAddMarshallingStrategyButtonClicked(ClickEvent ignore) {
        this.presenter.openNewMarshallingStrategyModal();
    }

    @EventHandler(value={"add-event-listener-button"})
    public void onAddEventListenerButtonClicked(ClickEvent ignore) {
        this.presenter.openNewEventListenerModal();
    }

    @EventHandler(value={"add-global-button"})
    public void onAddGlobalButtonClicked(ClickEvent ignore) {
        this.presenter.openNewGlobalModal();
    }

    @EventHandler(value={"add-required-role-button"})
    public void onAddRequiredRoleButtonClicked(ClickEvent ignore) {
        this.presenter.openNewRequiredRoleModal();
    }

    @Override
    public Element getEventListenersTable() {
        return this.eventListenersTable;
    }

    @Override
    public Element getMarshallingStrategiesTable() {
        return this.marshallingStrategiesTable;
    }

    @Override
    public Element getGlobalsTable() {
        return this.globalsTable;
    }

    @Override
    public Element getRequiredRolesTable() {
        return this.requiredRolesTable;
    }

    @Override
    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName.value = persistenceUnitName;
    }

    @Override
    public void setAuditPersistenceUnitName(String auditPersistenceUnitName) {
        this.auditPersistenceUnitName.value = auditPersistenceUnitName;
    }

    @Override
    public Element getRuntimeStrategiesContainer() {
        return this.runtimeStrategies;
    }

    @Override
    public Element getAuditModesContainer() {
        return this.auditModes;
    }

    @Override
    public String getConcurrentUpdateMessage() {
        return this.translationService.format(DeploymentsXmlConcurrentUpdate, new Object[0]);
    }

    @Override
    public Element getPersistenceModesContainer() {
        return this.persistenceModes;
    }

    public String getTitle() {
        return this.title.textContent;
    }
}

