/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import elemental2.dom.Element;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.NamedObjectItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.RequiredRolesListItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.AuditMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.PersistenceMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.Resolver;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.RuntimeStrategy;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.KieEnumSelectElement;
import org.kie.workbench.common.screens.library.client.settings.util.ListPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.modal.doublevalue.AddDoubleValueModal;
import org.kie.workbench.common.screens.library.client.settings.util.modal.single.AddSingleValueModal;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class DeploymentsSectionPresenter
extends SettingsPresenter.Section {
    private final View view;
    private final WorkspaceProjectContext projectContext;
    private final Caller<DDEditorService> ddEditorService;
    private final ManagedInstance<ObservablePath> observablePaths;
    private final MarshallingStrategiesListPresenter marshallingStrategyPresenters;
    private final EventListenersListPresenter eventListenerPresenters;
    private final GlobalsListPresenter globalPresenters;
    private final RequiredRolesListPresenter requiredRolePresenters;
    private final AddSingleValueModal addMarshallingStrategyModal;
    private final AddSingleValueModal addEventListenerModal;
    private final AddDoubleValueModal addGlobalModal;
    private final AddSingleValueModal addRequiredRoleModal;
    private final KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect;
    private final KieEnumSelectElement<PersistenceMode> persistenceModesSelect;
    private final KieEnumSelectElement<AuditMode> auditModesSelect;
    private final Event<NotificationEvent> notificationEvent;
    private ObservablePath pathToDeploymentsXml;
    ObservablePath.OnConcurrentUpdateEvent concurrentDeploymentsXmlUpdateInfo;
    DeploymentDescriptorModel model;

    @Inject
    public DeploymentsSectionPresenter(View view, Promises promises, SettingsPresenter.MenuItem menuItem, AddSingleValueModal addMarshallingStrategyModal, AddSingleValueModal addEventListenerModal, AddDoubleValueModal addGlobalModal, AddSingleValueModal addRequiredRoleModal, KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect, KieEnumSelectElement<PersistenceMode> persistenceModesSelect, KieEnumSelectElement<AuditMode> auditModesSelect, WorkspaceProjectContext projectContext, Caller<DDEditorService> ddEditorService, ManagedInstance<ObservablePath> observablePaths, Event<SettingsSectionChange> settingsSectionChangeEvent, MarshallingStrategiesListPresenter marshallingStrategyPresenters, EventListenersListPresenter eventListenerPresenters, GlobalsListPresenter globalPresenters, RequiredRolesListPresenter requiredRolePresenters, Event<NotificationEvent> notificationEvent) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.addMarshallingStrategyModal = addMarshallingStrategyModal;
        this.addEventListenerModal = addEventListenerModal;
        this.addGlobalModal = addGlobalModal;
        this.addRequiredRoleModal = addRequiredRoleModal;
        this.runtimeStrategiesSelect = runtimeStrategiesSelect;
        this.persistenceModesSelect = persistenceModesSelect;
        this.auditModesSelect = auditModesSelect;
        this.projectContext = projectContext;
        this.ddEditorService = ddEditorService;
        this.observablePaths = observablePaths;
        this.marshallingStrategyPresenters = marshallingStrategyPresenters;
        this.eventListenerPresenters = eventListenerPresenters;
        this.globalPresenters = globalPresenters;
        this.requiredRolePresenters = requiredRolePresenters;
        this.notificationEvent = notificationEvent;
    }

    public Promise<Void> setup(ProjectScreenModel ignore) {
        return this.setup();
    }

    Promise<Void> setup() {
        this.view.init((Object)this);
        String deploymentsXmlUri = ((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get()).getRootPath().toURI() + "src/main/resources/META-INF/kie-deployment-descriptor.xml";
        this.pathToDeploymentsXml = ((ObservablePath)this.observablePaths.get()).wrap(PathFactory.newPath((String)"kie-deployment-descriptor.xml", (String)deploymentsXmlUri));
        this.concurrentDeploymentsXmlUpdateInfo = null;
        this.pathToDeploymentsXml.onConcurrentUpdate(info -> {
            this.concurrentDeploymentsXmlUpdateInfo = info;
        });
        return this.createIfNotExists().then(ignore -> this.loadDeploymentDescriptor()).then(model -> {
            this.model = model;
            this.setupRuntimeStrategiesSelect((DeploymentDescriptorModel)model);
            this.view.setPersistenceUnitName(model.getPersistenceUnitName());
            this.setupPersistenceModesSelect((DeploymentDescriptorModel)model);
            this.view.setAuditPersistenceUnitName(model.getAuditPersistenceUnitName());
            this.setupAuditModeSelect((DeploymentDescriptorModel)model);
            this.setupMarshallingStrategiesTable((DeploymentDescriptorModel)model);
            this.setupEventListenersTable((DeploymentDescriptorModel)model);
            this.setupGlobalsTable((DeploymentDescriptorModel)model);
            this.setupRequiredRolesTable((DeploymentDescriptorModel)model);
            return this.promises.resolve();
        });
    }

    void setupAuditModeSelect(DeploymentDescriptorModel model) {
        this.auditModesSelect.setup(this.view.getAuditModesContainer(), (Enum[])AuditMode.values(), (Enum)AuditMode.valueOf(model.getAuditMode()), auditMode -> {
            model.setAuditMode(auditMode.name());
            this.fireChangeEvent();
        });
    }

    void setupPersistenceModesSelect(DeploymentDescriptorModel model) {
        this.persistenceModesSelect.setup(this.view.getPersistenceModesContainer(), (Enum[])PersistenceMode.values(), (Enum)PersistenceMode.valueOf(model.getPersistenceMode()), persistenceMode -> {
            model.setPersistenceMode(persistenceMode.name());
            this.fireChangeEvent();
        });
    }

    void setupRuntimeStrategiesSelect(DeploymentDescriptorModel model) {
        this.runtimeStrategiesSelect.setup(this.view.getRuntimeStrategiesContainer(), (Enum[])RuntimeStrategy.values(), (Enum)RuntimeStrategy.valueOf(model.getRuntimeStrategy()), runtimeStrategy -> {
            model.setRuntimeStrategy(runtimeStrategy.name());
            this.fireChangeEvent();
        });
    }

    void setupMarshallingStrategiesTable(DeploymentDescriptorModel model) {
        this.addMarshallingStrategyModal.setup("AddMarshallingStrategy", "Id");
        if (model.getMarshallingStrategies() == null) {
            model.setMarshallingStrategies(new ArrayList());
        }
        this.marshallingStrategyPresenters.setup(this.view.getMarshallingStrategiesTable(), model.getMarshallingStrategies(), (marshallingStrategy, presenter) -> presenter.setup((ItemObjectModel)marshallingStrategy, this));
    }

    void setupEventListenersTable(DeploymentDescriptorModel model) {
        this.addEventListenerModal.setup("AddEventListener", "Id");
        if (model.getEventListeners() == null) {
            model.setEventListeners(new ArrayList());
        }
        this.eventListenerPresenters.setup(this.view.getEventListenersTable(), model.getEventListeners(), (eventListener, presenter) -> presenter.setup((ItemObjectModel)eventListener, this));
    }

    void setupGlobalsTable(DeploymentDescriptorModel model) {
        this.addGlobalModal.setup("AddGlobal", "Name", "Value");
        if (model.getGlobals() == null) {
            model.setGlobals(new ArrayList());
        }
        this.globalPresenters.setup(this.view.getGlobalsTable(), model.getGlobals(), (global, presenter) -> presenter.setup((ItemObjectModel)global, this));
    }

    void setupRequiredRolesTable(DeploymentDescriptorModel model) {
        this.addRequiredRoleModal.setup("AddRequiredRole", "Role");
        if (model.getRequiredRoles() == null) {
            model.setRequiredRoles(new ArrayList());
        }
        this.requiredRolePresenters.setup(this.view.getRequiredRolesTable(), model.getRequiredRoles(), (requiredRole, presenter) -> presenter.setup((String)requiredRole, this));
    }

    Promise<DeploymentDescriptorModel> loadDeploymentDescriptor() {
        return this.promises.promisify(this.ddEditorService, s -> s.load((Path)this.pathToDeploymentsXml));
    }

    Promise<Void> createIfNotExists() {
        return this.promises.promisify(this.ddEditorService, s -> s.createIfNotExists((Path)this.pathToDeploymentsXml));
    }

    public void openNewMarshallingStrategyModal() {
        this.addMarshallingStrategyModal.show(this::addMarshallingStrategy);
    }

    public void openNewEventListenerModal() {
        this.addEventListenerModal.show(this::addEventListener);
    }

    public void openNewGlobalModal() {
        this.addGlobalModal.show(this::addGlobal);
    }

    public void openNewRequiredRoleModal() {
        this.addRequiredRoleModal.show(this::addRequiredRole);
    }

    void addMarshallingStrategy(String name) {
        this.marshallingStrategyPresenters.add(this.newObjectModelItem(name));
        this.fireChangeEvent();
    }

    void addEventListener(String name) {
        this.eventListenerPresenters.add(this.newObjectModelItem(name));
        this.fireChangeEvent();
    }

    void addGlobal(String name, String value) {
        this.globalPresenters.add(this.newNamedObjectModelItem(name, value));
        this.fireChangeEvent();
    }

    void addRequiredRole(String role) {
        this.requiredRolePresenters.add(role);
        this.fireChangeEvent();
    }

    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        if (this.concurrentDeploymentsXmlUpdateInfo == null) {
            return this.save(comment);
        }
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getConcurrentUpdateMessage(), NotificationEvent.NotificationType.WARNING));
        return this.setup();
    }

    Promise<Void> save(String comment) {
        return this.promises.promisify(this.ddEditorService, s -> s.save((Path)this.pathToDeploymentsXml, (Object)this.model, this.model.getOverview().getMetadata(), comment));
    }

    ItemObjectModel newObjectModelItem(String name) {
        ItemObjectModel model = new ItemObjectModel();
        model.setValue(name);
        model.setResolver(Resolver.MVEL.name().toLowerCase());
        model.setParameters(new ArrayList());
        return model;
    }

    ItemObjectModel newNamedObjectModelItem(String name, String value) {
        ItemObjectModel model = new ItemObjectModel();
        model.setName(name);
        model.setValue(value);
        model.setResolver(Resolver.MVEL.name().toLowerCase());
        model.setParameters(new ArrayList());
        return model;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.model.setPersistenceUnitName(persistenceUnitName);
        this.fireChangeEvent();
    }

    public void setAuditPersistenceUnitName(String auditPersistenceUnitName) {
        this.model.setAuditPersistenceUnitName(auditPersistenceUnitName);
        this.fireChangeEvent();
    }

    public int currentHashCode() {
        return this.model.hashCode();
    }

    public SettingsPresenter.View.Section getView() {
        return this.view;
    }

    @Dependent
    public static class RequiredRolesListPresenter
    extends ListPresenter<String, RequiredRolesListItemPresenter> {
        @Inject
        public RequiredRolesListPresenter(ManagedInstance<RequiredRolesListItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class GlobalsListPresenter
    extends ListPresenter<ItemObjectModel, NamedObjectItemPresenter> {
        @Inject
        public GlobalsListPresenter(ManagedInstance<NamedObjectItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class EventListenersListPresenter
    extends ListPresenter<ItemObjectModel, ObjectItemPresenter> {
        @Inject
        public EventListenersListPresenter(ManagedInstance<ObjectItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class MarshallingStrategiesListPresenter
    extends ListPresenter<ItemObjectModel, ObjectItemPresenter> {
        @Inject
        public MarshallingStrategiesListPresenter(ManagedInstance<ObjectItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends SettingsPresenter.View.Section<DeploymentsSectionPresenter> {
        public Element getMarshallingStrategiesTable();

        public Element getEventListenersTable();

        public Element getGlobalsTable();

        public Element getRequiredRolesTable();

        public void setPersistenceUnitName(String var1);

        public void setAuditPersistenceUnitName(String var1);

        public Element getRuntimeStrategiesContainer();

        public Element getPersistenceModesContainer();

        public Element getAuditModesContainer();

        public String getConcurrentUpdateMessage();
    }
}

