/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem.project;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.project.ServiceTaskInstallFormView;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

public class ServiceTaskInstallFormViewImpl
extends BaseModal
implements ServiceTaskInstallFormView {
    private String serviceTaskId;
    private String target;
    private String referenceLink;
    private FormStyleLayout form;
    private ServiceTaskInstallFormView.Presenter presenter;
    private List<TextBox> fields = new ArrayList<TextBox>();

    public ServiceTaskInstallFormViewImpl() {
        this.setTitle(Constants.INSTANCE.InstallServiceTaskParams());
    }

    private void doForm(List<String> parameters) {
        this.form = new FormStyleLayout();
        this.form.setType(FormType.HORIZONTAL);
        Anchor link = new Anchor();
        link.setText(this.referenceLink);
        link.setHref(this.referenceLink);
        link.setTarget("_blank");
        this.form.addAttribute("Reference Link", (IsWidget)link);
        for (String param : parameters) {
            TextBox paramField = (TextBox)GWT.create(TextBox.class);
            this.form.addAttribute(param, (IsWidget)paramField);
            this.fields.add(paramField);
        }
        this.setBody((Widget)this.form);
        Button installButton = new Button(Constants.INSTANCE.InstallServiceTask());
        installButton.setType(ButtonType.PRIMARY);
        installButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                List<String> parameters = ServiceTaskInstallFormViewImpl.this.fields.stream().map(textbox -> textbox.getValue()).collect(Collectors.toList());
                ServiceTaskInstallFormViewImpl.this.presenter.installWithParameters(ServiceTaskInstallFormViewImpl.this.serviceTaskId, ServiceTaskInstallFormViewImpl.this.target, parameters);
                ServiceTaskInstallFormViewImpl.this.hide();
            }
        });
        ModalFooter footer = new ModalFooter();
        Button cancelButton = new Button(Constants.INSTANCE.Cancel());
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServiceTaskInstallFormViewImpl.this.hide();
            }
        });
        footer.add((Widget)installButton);
        footer.add((Widget)cancelButton);
        this.add((Widget)footer);
    }

    public void init(ServiceTaskInstallFormView.Presenter presenter) {
        this.presenter = presenter;
        this.addHideHandler(evt -> this.presenter.onCloseCommand().execute());
    }

    @Override
    public void showInstallBusy() {
        BusyPopup.showMessage((String)Constants.INSTANCE.Installing());
    }

    @Override
    public void hideInstallBusy() {
        BusyPopup.close();
    }

    @Override
    public void show(String serviceTaskId, String target, List<String> parameters, String referenceLink) {
        this.serviceTaskId = serviceTaskId;
        this.target = target;
        this.referenceLink = referenceLink;
        this.doForm(parameters);
        super.show();
    }
}

