/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskadmin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Legend;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskAdminViewImpl.html")
public class TaskAdminViewImpl
extends Composite
implements TaskAdminPresenter.TaskAdminView {
    @Inject
    @DataField
    public Legend adminDetailsAccordionLabel;
    @Inject
    @DataField
    public FormLabel adminUserOrGroupLabel;
    @Inject
    @DataField
    public FormLabel adminUsersGroupsControlsLabel;
    @Inject
    @DataField
    public TextBox adminUserOrGroupText;
    @Inject
    @DataField
    public Button adminForwardButton;
    @Inject
    @DataField
    public FormControlStatic adminUsersGroupsControlsPanel;
    @Inject
    @DataField
    public Legend reminderDetailsAccordionLabel;
    @Inject
    @DataField
    public FormLabel actualOwnerLabel;
    @Inject
    @DataField
    public FormControlStatic actualOwnerPanel;
    @Inject
    @DataField
    public Button adminReminderButton;
    private TaskAdminPresenter presenter;
    @Inject
    private Event<NotificationEvent> notification;
    private Constants constants = (Constants)GWT.create(Constants.class);

    @Override
    public void init(TaskAdminPresenter presenter) {
        this.presenter = presenter;
        this.adminUserOrGroupLabel.setText(this.constants.Delegate_User());
        this.adminDetailsAccordionLabel.setText(this.constants.Details());
        this.adminForwardButton.setText(this.constants.Forward());
        this.adminUsersGroupsControlsLabel.setText(this.constants.Potential_Owners());
        this.reminderDetailsAccordionLabel.setText(this.constants.Reminder_Details());
        this.actualOwnerLabel.setText(this.constants.Actual_Owner());
        this.adminReminderButton.setText(this.constants.Reminder());
    }

    @EventHandler(value={"adminForwardButton"})
    public void adminForwardButton(ClickEvent e) {
        String userOrGroup = this.adminUserOrGroupText.getText();
        if (!userOrGroup.equals("")) {
            this.presenter.forwardTask(userOrGroup);
            this.adminForwardButton.setEnabled(false);
        } else {
            this.displayNotification(this.constants.PleaseEnterUserOrAGroupToDelegate());
        }
    }

    @EventHandler(value={"adminReminderButton"})
    public void adminReminderButton(ClickEvent e) {
        this.presenter.reminder();
    }

    @Override
    public FormControlStatic getUsersGroupsControlsPanel() {
        return this.adminUsersGroupsControlsPanel;
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @Override
    public Button getForwardButton() {
        return this.adminForwardButton;
    }

    @Override
    public TextBox getUserOrGroupText() {
        return this.adminUserOrGroupText;
    }

    @Override
    public Button getReminderButton() {
        return this.adminReminderButton;
    }

    @Override
    public FormControlStatic getActualOwnerPanel() {
        return this.actualOwnerPanel;
    }
}

