/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import com.google.gwt.user.client.TakesValue;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListLoadEvent;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListOpenEvent;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.roles.util.ItemsLine;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;

@Dependent
@Templated
public class CaseRoleItemView
extends AbstractView<CaseRolesPresenter>
implements TakesValue<CaseRoleAssignmentSummary>,
IsElement {
    public static String USERS_LINE_ID = "_users";
    public static String GROUP_LINE_ID = "_groups";
    @Inject
    protected TranslationService translationService;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-button")
    Button actionsButton;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    @DataField(value="role-name")
    @Bound
    Span name;
    @Inject
    @DataField(value="div-unassigned")
    Div unassignedDiv;
    @Inject
    @DataField(value="line-users")
    ItemsLine usersItemsLine;
    @Inject
    @DataField(value="div-users")
    Div usersDiv;
    @Inject
    @DataField(value="line-groups")
    ItemsLine groupsItemsLine;
    @Inject
    @DataField(value="div-groups")
    Div groupsDiv;
    @Inject
    ConfirmPopup confirmPopup;
    @Inject
    private CaseRolesPresenter.EditRoleAssignmentView editRoleAssignmentDialog;
    @Inject
    @AutoBound
    private DataBinder<CaseRoleAssignmentSummary> caseRoleAssignmentSummary;

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public CaseRoleAssignmentSummary getValue() {
        return (CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel();
    }

    public void setValue(CaseRoleAssignmentSummary model) {
        this.caseRoleAssignmentSummary.setModel((Object)model);
    }

    public void displayOwnerActions() {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.actionsItems, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.actionsButton, (String)"disabled");
    }

    public void displayEnabledAction(CaseRolesPresenter.CaseRoleAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement li = Window.getDocument().createElement("li");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        DOMUtil.addCSSClass((HTMLElement)a, (String)"kie-more-info-link");
        a.setOnclick(e -> action.execute());
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void displayDisabledAction(CaseRolesPresenter.CaseRoleAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement li = Window.getDocument().createElement("li");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        DOMUtil.addCSSClass((HTMLElement)li, (String)"disabled");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void displayOwnerAssignment() {
        this.hideGroupAssignments();
        String owner = (String)this.getValue().getUsers().get(0);
        this.usersItemsLine.initWithSingleItem("owner", owner);
    }

    public void hideGroupAssignments() {
        this.displaySingleAssignment(this.usersDiv, this.groupsDiv);
    }

    public void hideUserAssignments() {
        this.displaySingleAssignment(this.groupsDiv, this.usersDiv);
    }

    private void displaySingleAssignment(Div divToExpand, Div divToHide) {
        DOMUtil.addCSSClass((HTMLElement)divToExpand, (String)"kie-single-role-assignment-height");
        DOMUtil.addCSSClass((HTMLElement)divToHide, (String)"hidden");
    }

    public void displayUnassigned() {
        DOMUtil.addCSSClass((HTMLElement)this.usersDiv, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.groupsDiv, (String)"hidden");
        DOMUtil.removeCSSClass((HTMLElement)this.unassignedDiv, (String)"hidden");
    }

    public void displayAssignmentsList(String listId, int listWidth, List<CaseRolesPresenter.CaseAssignmentItem> assignmentsList) {
        if (USERS_LINE_ID.equals(listId)) {
            this.usersItemsLine.initWithItemsLine(listWidth, this.name.getTextContent() + USERS_LINE_ID, assignmentsList);
        } else if (GROUP_LINE_ID.equals(listId)) {
            this.groupsItemsLine.initWithItemsLine(listWidth, this.name.getTextContent() + GROUP_LINE_ID, assignmentsList);
        }
    }

    public void showEditRoleAssignmentDialog() {
        String roleName = this.getValue().getName();
        CaseRoleAssignmentSummary currentRoleAssignments = CaseRoleAssignmentSummary.builder().name(roleName).users(this.getValue().getUsers()).groups(this.getValue().getGroups()).build();
        this.editRoleAssignmentDialog.setValue(currentRoleAssignments);
        this.editRoleAssignmentDialog.show(() -> ((CaseRolesPresenter)this.presenter).assignToRole(this, this.getNewRoleAssignments()));
    }

    private CaseRoleAssignmentSummary getNewRoleAssignments() {
        return (CaseRoleAssignmentSummary)this.editRoleAssignmentDialog.getValue();
    }

    public void showErrorState() {
        this.editRoleAssignmentDialog.setErrorState();
    }

    public void showAssignmentErrors(List<String> caseRoleAssignmentErrors) {
        this.editRoleAssignmentDialog.showValidationError(caseRoleAssignmentErrors);
    }

    public void hideEditRoleAssignmentDialog() {
        this.editRoleAssignmentDialog.hide();
    }

    public void showRemoveAllAssignmentsPopup() {
        this.confirmPopup.show(this.translationService.format("RemoveAssignment", new Object[0]), this.translationService.format("Remove", new Object[0]), this.translationService.format("RemoveAllUsersAndGroupsForRole", new Object[]{this.getValue().getName()}), () -> ((CaseRolesPresenter)this.presenter).storeRoleAssignments(this.getValue(), Collections.emptyList(), Collections.emptyList()));
    }

    public void showRemoveUserAssignmentPopup(String user) {
        this.confirmPopup.show(this.translationService.format("RemoveAssignment", new Object[0]), this.translationService.format("Remove", new Object[0]), this.translationService.format("RemoveUserAssignmentFromRole", new Object[]{user, this.getValue().getName()}), () -> ((CaseRolesPresenter)this.presenter).removeUserFromRole(user, this.getValue()));
    }

    public void showRemoveGroupAssignmentPopup(String group) {
        this.confirmPopup.show(this.translationService.format("RemoveAssignment", new Object[0]), this.translationService.format("Remove", new Object[0]), this.translationService.format("RemoveGroupAssignmentFromRole", new Object[]{group, this.getValue().getName()}), () -> ((CaseRolesPresenter)this.presenter).removeGroupFromRole(group, this.getValue()));
    }

    public void setLastElementStyle() {
        DOMUtil.addCSSClass((HTMLElement)this.actions, (String)"dropup");
    }

    public void onCaseRoleAssignmentListOpenEvent(@Observes CaseRoleAssignmentListOpenEvent event) {
        String lineId = event.getAssignmentLineId();
        if (lineId.equals(this.name.getTextContent() + USERS_LINE_ID)) {
            this.groupsItemsLine.hideAllItems();
        } else if (lineId.equals(this.name.getTextContent() + GROUP_LINE_ID)) {
            this.usersItemsLine.hideAllItems();
        } else {
            this.usersItemsLine.hideAllItems();
            this.groupsItemsLine.hideAllItems();
        }
    }

    public void onCaseRoleAssignmentListLoadEvent(@Observes CaseRoleAssignmentListLoadEvent event) {
        this.displayCaseRoleActions();
        this.displayCaseRoleAssignments(event.getMaxWidth());
    }

    private void displayCaseRoleActions() {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"dropup");
        ((CaseRolesPresenter)this.presenter).setCaseRoleActions(this);
    }

    private void displayCaseRoleAssignments(int maxWidth) {
        ((CaseRolesPresenter)this.presenter).setCaseRoleAssignments(this, maxWidth);
    }
}

