/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import com.google.gwt.user.client.TakesValue;
import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListLoadEvent;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListOpenEvent;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.roles.util.ItemsLine;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;

@Dependent
@Templated
public class CaseRoleItemView
extends AbstractView<CaseRolesPresenter>
implements TakesValue<CaseRoleAssignmentSummary>,
IsElement {
    public static String USERS_LINE_ID = "_users";
    public static String GROUP_LINE_ID = "_groups";
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-button")
    Button actionsButton;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    @DataField(value="role-name")
    @Bound
    Span name;
    @Inject
    @DataField(value="div-unassigned")
    Div unassignedDiv;
    @Inject
    @DataField(value="line-users")
    ItemsLine usersItemsLine;
    @Inject
    @DataField(value="div-users")
    Div usersDiv;
    @Inject
    @DataField(value="line-groups")
    ItemsLine groupsItemsLine;
    @Inject
    @DataField(value="div-groups")
    Div groupsDiv;
    @Inject
    ConfirmPopup confirmPopup;
    @Inject
    protected TranslationService translationService;
    @Inject
    @AutoBound
    private DataBinder<CaseRoleAssignmentSummary> caseRoleAssignmentSummary;

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public CaseRoleAssignmentSummary getValue() {
        return (CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel();
    }

    public void setValue(final CaseRoleAssignmentSummary model) {
        this.caseRoleAssignmentSummary.setModel((Object)model);
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"dropup");
        if ("owner".equals(model.getName())) {
            this.setOwnerAssignment();
        } else {
            final boolean hasAssignment = model.hasAssignment();
            this.addAction(new CaseRolesPresenter.CaseRoleAction(){

                @Override
                public String label() {
                    if (hasAssignment) {
                        return CaseRoleItemView.this.translationService.format("Edit", new Object[0]);
                    }
                    return CaseRoleItemView.this.translationService.format("Assign", new Object[0]);
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                public void execute() {
                    ((CaseRolesPresenter)CaseRoleItemView.this.presenter).editAction(model);
                }
            });
            this.addAction(new CaseRolesPresenter.CaseRoleAction(){

                @Override
                public String label() {
                    return CaseRoleItemView.this.translationService.format("RemoveAllAssignments", new Object[0]);
                }

                @Override
                public boolean isEnabled() {
                    return hasAssignment;
                }

                public void execute() {
                    CaseRoleItemView.this.confirmPopup.show(CaseRoleItemView.this.translationService.format("RemoveAssignment", new Object[0]), CaseRoleItemView.this.translationService.format("Remove", new Object[0]), CaseRoleItemView.this.translationService.format("RemoveAllUsersAndGroupsForRole", new Object[]{model.getName()}), () -> ((CaseRolesPresenter)CaseRoleItemView.this.presenter).storeRoleAssignments(model, Collections.emptyList(), Collections.emptyList()));
                }
            });
        }
    }

    public void setCaseRoleAssignments(int maxWidth) {
        if (!"owner".equals(((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getName())) {
            if (!((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).hasAssignment()) {
                this.displayUnassigned();
            } else {
                ArrayList<CaseRolesPresenter.CaseAssignmentItem> itemsList;
                if (((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getUsers().size() == 0) {
                    this.setSingleLineAssignment(this.groupsDiv, this.usersDiv);
                } else {
                    itemsList = new ArrayList<CaseRolesPresenter.CaseAssignmentItem>();
                    ((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getUsers().forEach(user -> itemsList.add(new CaseRolesPresenter.CaseAssignmentItem((String)user){
                        final /* synthetic */ String val$user;
                        {
                            this.val$user = string;
                        }

                        @Override
                        public String label() {
                            return this.val$user;
                        }

                        public void execute() {
                            CaseRoleItemView.this.confirmPopup.show(CaseRoleItemView.this.translationService.format("RemoveAssignment", new Object[0]), CaseRoleItemView.this.translationService.format("Remove", new Object[0]), CaseRoleItemView.this.translationService.format("RemoveUserAssignmentFromRole", new Object[]{this.val$user, ((CaseRoleAssignmentSummary)CaseRoleItemView.this.caseRoleAssignmentSummary.getModel()).getName()}), () -> ((CaseRolesPresenter)CaseRoleItemView.this.presenter).removeUserFromRole(this.val$user, (CaseRoleAssignmentSummary)CaseRoleItemView.this.caseRoleAssignmentSummary.getModel()));
                        }
                    }));
                    this.usersItemsLine.initWithItemsLine(maxWidth, this.name.getTextContent() + USERS_LINE_ID, itemsList);
                }
                if (((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getGroups().size() == 0) {
                    this.setSingleLineAssignment(this.usersDiv, this.groupsDiv);
                } else {
                    itemsList = new ArrayList();
                    ((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getGroups().forEach(group -> itemsList.add(new CaseRolesPresenter.CaseAssignmentItem((String)group){
                        final /* synthetic */ String val$group;
                        {
                            this.val$group = string;
                        }

                        @Override
                        public String label() {
                            return this.val$group;
                        }

                        public void execute() {
                            CaseRoleItemView.this.confirmPopup.show(CaseRoleItemView.this.translationService.format("RemoveAssignment", new Object[0]), CaseRoleItemView.this.translationService.format("Remove", new Object[0]), CaseRoleItemView.this.translationService.format("RemoveGroupAssignmentFromRole", new Object[]{this.val$group, ((CaseRoleAssignmentSummary)CaseRoleItemView.this.caseRoleAssignmentSummary.getModel()).getName()}), () -> ((CaseRolesPresenter)CaseRoleItemView.this.presenter).removeGroupFromRole(this.val$group, (CaseRoleAssignmentSummary)CaseRoleItemView.this.caseRoleAssignmentSummary.getModel()));
                        }
                    }));
                    this.groupsItemsLine.initWithItemsLine(maxWidth, this.name.getTextContent() + GROUP_LINE_ID, itemsList);
                }
            }
        }
    }

    public void setOwnerAssignment() {
        this.usersItemsLine.initWithSingleItem(this.name.getTextContent(), (String)((CaseRoleAssignmentSummary)this.caseRoleAssignmentSummary.getModel()).getUsers().get(0));
        this.setSingleLineAssignment(this.usersDiv, this.groupsDiv);
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.actionsItems, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.actionsButton, (String)"disabled");
    }

    private void setSingleLineAssignment(Div divToExpand, Div divTohide) {
        DOMUtil.addCSSClass((HTMLElement)divToExpand, (String)"kie-single-role-assignment-height");
        DOMUtil.addCSSClass((HTMLElement)divTohide, (String)"hidden");
    }

    public void displayUnassigned() {
        DOMUtil.addCSSClass((HTMLElement)this.usersDiv, (String)"hidden");
        DOMUtil.addCSSClass((HTMLElement)this.groupsDiv, (String)"hidden");
        DOMUtil.removeCSSClass((HTMLElement)this.unassignedDiv, (String)"hidden");
    }

    public void addAction(CaseRolesPresenter.CaseRoleAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement li = Window.getDocument().createElement("li");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        if (!action.isEnabled()) {
            DOMUtil.addCSSClass((HTMLElement)li, (String)"disabled");
        } else {
            DOMUtil.addCSSClass((HTMLElement)a, (String)"kie-more-info-link");
            a.setOnclick(e -> action.execute());
            li.appendChild((Node)a);
        }
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void setLastElementStyle() {
        DOMUtil.addCSSClass((HTMLElement)this.actions, (String)"dropup");
    }

    public void onCaseRoleAssignmentLineOpenEvent(@Observes CaseRoleAssignmentListOpenEvent event) {
        String lineId = event.getAssignmentLineId();
        if (lineId.equals(this.name.getTextContent() + USERS_LINE_ID)) {
            this.groupsItemsLine.hideAllItems();
        } else if (lineId.equals(this.name.getTextContent() + GROUP_LINE_ID)) {
            this.usersItemsLine.hideAllItems();
        } else {
            this.usersItemsLine.hideAllItems();
            this.groupsItemsLine.hideAllItems();
        }
    }

    public void onCaseRoleAssignmentLineLoadEvent(@Observes CaseRoleAssignmentListLoadEvent event) {
        this.setCaseRoleAssignments(event.getMaxWidth());
    }
}

