/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.client.newcase.RoleAssignmentViewImpl;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.FormGroup;
import org.jbpm.workbench.cm.client.util.FormLabel;
import org.jbpm.workbench.cm.client.util.InlineNotification;
import org.jbpm.workbench.cm.client.util.Modal;
import org.jbpm.workbench.cm.client.util.Popover;
import org.jbpm.workbench.cm.client.util.Select;
import org.jbpm.workbench.cm.client.util.ValidationState;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;

@Dependent
@Templated
public class NewCaseInstanceViewImpl
extends AbstractView<NewCaseInstancePresenter>
implements NewCaseInstancePresenter.NewCaseInstanceView {
    @Inject
    @DataField(value="definition-name-group")
    private FormGroup caseDefinitionNameGroup;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    @DataField(value="definition-name-help")
    private Span definitionNameHelp;
    @Inject
    @DataField(value="definition-name-select")
    private Select caseTemplatesList;
    @Inject
    @DataField(value="owner-name-input")
    private TextInput ownerNameInput;
    @Inject
    @DataField(value="owner-name-help")
    private Span ownerNameHelp;
    @Inject
    @DataField(value="owner-name-group")
    private FormGroup ownerNameGroup;
    @Inject
    @DataField(value="owner-name-label")
    private FormLabel ownerNameLabel;
    @Inject
    @DataField(value="definition-name-label")
    private FormLabel caseDefinitionNameLabel;
    @Inject
    @DataField(value="roles-form-group")
    private Div rolesFormGroup;
    @Inject
    @DataField(value="alert")
    private InlineNotification notification;
    @Inject
    @Bound
    @ListContainer(value="tbody")
    @DataField(value="roles")
    private ListComponent<CaseRoleAssignmentSummary, RoleAssignmentViewImpl> roleAssignments;
    @Inject
    @AutoBound
    private DataBinder<List<CaseRoleAssignmentSummary>> roleAssignmentList;
    @Inject
    @DataField(value="roles-help")
    private Popover rolesHelp;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.caseDefinitionNameLabel.addRequiredIndicator();
        this.ownerNameLabel.addRequiredIndicator();
        this.rolesHelp.setContent(this.translationService.getTranslation("RolesInfoText"));
        this.notification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    @Override
    public void show() {
        this.cleanForm();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.cleanForm();
        this.modal.hide();
    }

    @Override
    public void clearCaseDefinitions() {
        this.caseTemplatesList.removeAllOptions();
    }

    @Override
    public void clearRoles() {
        this.roleAssignmentList.setModel(Collections.emptyList());
        DOMUtil.addCSSClass((HTMLElement)this.rolesFormGroup, (String)"hidden");
    }

    @Override
    public void setCaseDefinitions(List<CaseDefinitionSummary> definitions) {
        this.clearCaseDefinitions();
        this.caseTemplatesList.setValue("");
        Map<String, List<CaseDefinitionSummary>> nameToDefinitions = definitions.stream().collect(Collectors.groupingBy(CaseDefinitionSummary::getName));
        nameToDefinitions.entrySet().forEach(entry -> {
            if (((List)entry.getValue()).size() > 1) {
                ((List)entry.getValue()).forEach(def -> this.caseTemplatesList.addOption(def.getName(), def.getContainerId(), def.getUniqueId(), false));
            } else {
                CaseDefinitionSummary def2 = (CaseDefinitionSummary)((List)entry.getValue()).get(0);
                this.caseTemplatesList.addOption(def2.getName(), def2.getUniqueId());
            }
        });
        this.caseTemplatesList.refresh();
        this.loadCaseRoles();
    }

    @Override
    public void setRoles(List<CaseRoleAssignmentSummary> roles) {
        if (roles.size() > 0) {
            DOMUtil.removeCSSClass((HTMLElement)this.rolesFormGroup, (String)"hidden");
        }
        this.roleAssignmentList.setModel(roles);
    }

    public void cleanForm() {
        this.caseTemplatesList.setValue("");
        this.caseTemplatesList.getElement().focus();
        this.caseTemplatesList.enable();
        this.ownerNameInput.setValue("");
        DOMUtil.addCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
        this.clearErrorMessages();
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        boolean valid = true;
        if (Strings.isNullOrEmpty((String)this.caseTemplatesList.getValue())) {
            this.caseTemplatesList.getElement().focus();
            this.definitionNameHelp.setTextContent(this.translationService.format("PleaseSelectCase", new Object[0]));
            this.caseDefinitionNameGroup.setValidationState(ValidationState.ERROR);
            valid = false;
        }
        if (Strings.isNullOrEmpty((String)this.ownerNameInput.getValue())) {
            this.ownerNameInput.focus();
            this.ownerNameHelp.setTextContent(this.translationService.format("PleaseProvideCaseOwner", new Object[0]));
            this.ownerNameGroup.setValidationState(ValidationState.ERROR);
            valid = false;
        }
        if (valid) {
            this.caseDefinitionNameGroup.setValidationState(ValidationState.SUCCESS);
            this.ownerNameGroup.setValidationState(ValidationState.SUCCESS);
        }
        return valid;
    }

    @Override
    public void showError(List<String> messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.notification.setMessage(messages);
        DOMUtil.removeCSSClass((HTMLElement)this.notification.getElement(), (String)"hidden");
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    private void createCaseInstance() {
        ((NewCaseInstancePresenter)this.presenter).createCaseInstance(this.caseTemplatesList.getValue(), this.ownerNameInput.getValue(), (List)this.roleAssignmentList.getModel());
    }

    private void clearErrorMessages() {
        this.definitionNameHelp.setTextContent("");
        this.ownerNameHelp.setTextContent("");
        this.notification.setMessage("");
        this.caseDefinitionNameGroup.clearValidationState();
        this.ownerNameGroup.clearValidationState();
    }

    @Override
    public void setOwner(String owner) {
        this.ownerNameInput.setValue(owner);
    }

    @EventHandler(value={"start"})
    public void onCreateClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.validateForm()) {
            this.createCaseInstance();
        }
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"definition-name-select"})
    public void onCaseChanged(@ForEvent(value={"change"}) Event event) {
        this.loadCaseRoles();
    }

    private void loadCaseRoles() {
        ((NewCaseInstancePresenter)this.presenter).loadCaseRoles(this.caseTemplatesList.getValue());
    }
}

