/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.util.AbstractPresenter;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewCaseInstancePresenter
extends AbstractPresenter<NewCaseInstanceView> {
    private Map<String, CaseDefinitionSummary> caseDefinitions = new HashMap<String, CaseDefinitionSummary>();
    private Caller<CaseManagementService> caseService;
    private Event<NotificationEvent> notification;
    private Event<CaseCreatedEvent> newCaseEvent;
    @Inject
    private TranslationService translationService;
    @Inject
    private User identity;

    protected void loadCaseRoles(String caseDefinition) {
        ((NewCaseInstanceView)this.view).clearRoles();
        if (Strings.isNullOrEmpty((String)caseDefinition)) {
            return;
        }
        CaseDefinitionSummary caseDefinitionSummary = this.caseDefinitions.get(caseDefinition);
        if (caseDefinitionSummary == null) {
            return;
        }
        List<CaseRoleAssignmentSummary> roles = caseDefinitionSummary.getRoles().keySet().stream().filter(r -> !"owner".equals(r)).map(r -> CaseRoleAssignmentSummary.builder().name(r).build()).collect(Collectors.toList());
        ((NewCaseInstanceView)this.view).setRoles(roles);
    }

    public void show() {
        this.loadCaseDefinitions();
    }

    protected void loadCaseDefinitions() {
        ((NewCaseInstanceView)this.view).clearCaseDefinitions();
        this.caseDefinitions.clear();
        ((CaseManagementService)this.caseService.call(definitions -> {
            if (definitions.isEmpty()) {
                this.notification.fire((Object)new NotificationEvent(this.translationService.format("NoCaseDefinition", new Object[0]), NotificationEvent.NotificationType.ERROR));
                return;
            }
            this.caseDefinitions = definitions.stream().collect(Collectors.toMap(s -> s.getName(), s -> s));
            List<String> caseDefinitions = this.caseDefinitions.values().stream().map(s -> s.getName()).sorted().collect(Collectors.toList());
            ((NewCaseInstanceView)this.view).show();
            ((NewCaseInstanceView)this.view).setCaseDefinitions(caseDefinitions);
            this.loadCaseRoles((String)Iterables.getFirst(caseDefinitions, null));
            ((NewCaseInstanceView)this.view).setOwner(this.identity.getIdentifier());
        })).getCaseDefinitions();
    }

    protected void createCaseInstance(String caseDefinitionName, String owner, List<CaseRoleAssignmentSummary> assignments) {
        CaseDefinitionSummary caseDefinition = this.caseDefinitions.get(caseDefinitionName);
        if (caseDefinition == null) {
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("InvalidCaseDefinition", new Object[0]), NotificationEvent.NotificationType.ERROR));
            return;
        }
        List<String> assignmentErrors = this.validateRolesAssignments(caseDefinition, assignments);
        if (!assignmentErrors.isEmpty()) {
            ((NewCaseInstanceView)this.view).showError(assignmentErrors);
            return;
        }
        ((CaseManagementService)this.caseService.call(caseId -> {
            ((NewCaseInstanceView)this.view).hide();
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("CaseCreatedWithId", new Object[]{caseId}), NotificationEvent.NotificationType.SUCCESS));
            this.newCaseEvent.fire((Object)new CaseCreatedEvent((String)caseId));
        }, (message, t) -> {
            ((NewCaseInstanceView)this.view).showError(Collections.singletonList(t.getMessage()));
            return false;
        })).startCaseInstance(null, caseDefinition.getContainerId(), caseDefinition.getId(), owner, assignments);
    }

    protected List<String> validateRolesAssignments(CaseDefinitionSummary caseDefinition, List<CaseRoleAssignmentSummary> assignments) {
        ArrayList<String> errors = new ArrayList<String>();
        assignments.forEach(a -> {
            Integer roleCardinality = (Integer)caseDefinition.getRoles().get(a.getName());
            if (roleCardinality == -1) {
                return;
            }
            Integer roleAssignments = a.getUsers().size() + a.getGroups().size();
            if (roleAssignments > roleCardinality) {
                errors.add(this.translationService.format("InvalidRoleAssignment", new Object[]{a.getName(), roleCardinality}));
            }
        });
        return errors;
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    @Inject
    public void setNewCaseEvent(Event<CaseCreatedEvent> newCaseEvent) {
        this.newCaseEvent = newCaseEvent;
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }

    public static interface NewCaseInstanceView
    extends UberElement<NewCaseInstancePresenter> {
        public void show();

        public void hide();

        public void clearCaseDefinitions();

        public void setCaseDefinitions(List<String> var1);

        public void clearRoles();

        public void setRoles(List<CaseRoleAssignmentSummary> var1);

        public void setOwner(String var1);

        public void showError(List<String> var1);
    }
}

