/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.comments;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.comments.CaseCommentItemView;
import org.jbpm.workbench.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.workbench.cm.client.pagination.PaginationViewImpl;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.FormGroup;
import org.jbpm.workbench.cm.client.util.ValidationState;
import org.jbpm.workbench.cm.model.CaseCommentSummary;

@Dependent
@Templated
public class CaseCommentsViewImpl
extends AbstractView<CaseCommentsPresenter>
implements CaseCommentsPresenter.CaseCommentsView,
PaginationViewImpl.PageList {
    private int PAGE_SIZE = 20;
    @Inject
    @DataField(value="comments")
    Div commentsContainer;
    @Inject
    @DataField(value="sort-alpha-asc")
    private Button sortAlphaAsc;
    @Inject
    @DataField(value="sort-alpha-desc")
    private Button sortAlphaDesc;
    @Inject
    @Bound
    @DataField(value="comments-list")
    private ListComponent<CaseCommentSummary, CaseCommentItemView> comments;
    @Inject
    @AutoBound
    private DataBinder<List<CaseCommentSummary>> caseCommentList;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="comment-creation-input")
    Input newCommentTextArea;
    @Inject
    @DataField(value="comment-creation-help")
    Span newCommentTextAreaHelp;
    @Inject
    @DataField(value="comment-creation-group")
    FormGroup newCommentTextAreaGroup;
    @Inject
    @DataField
    Anchor addCommentButton;
    @Inject
    @DataField(value="scrollbox")
    private Div scrollbox;
    @Inject
    @DataField(value="pagination")
    private PaginationViewImpl pagination;
    @Inject
    private TranslationService translationService;
    List<CaseCommentSummary> allCommentsList;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.sortAlphaAsc);
        this.sortAlphaAsc.setAttribute("data-original-title", this.translationService.format("SortByDateDesc", new Object[0]));
        this.tooltip((HTMLElement)this.sortAlphaDesc);
        this.sortAlphaDesc.setAttribute("data-original-title", this.translationService.format("SortByDateAsc", new Object[0]));
    }

    public HTMLElement getElement() {
        return this.commentsContainer;
    }

    @Override
    public void init(CaseCommentsPresenter presenter) {
        this.presenter = presenter;
        this.comments.addComponentCreationHandler(v -> v.init(presenter));
    }

    @Override
    public void clearCommentInputForm() {
        this.newCommentTextArea.setValue("");
        this.clearErrorMessages();
    }

    public void clearErrorMessages() {
        this.newCommentTextAreaHelp.setTextContent("");
        this.newCommentTextAreaGroup.clearValidationState();
    }

    @Override
    public void resetPagination() {
        this.pagination.setCurrentPage(0);
        this.onSortChange((HTMLElement)this.sortAlphaAsc, (HTMLElement)this.sortAlphaDesc, false);
    }

    @Override
    public void setCaseCommentList(List<CaseCommentSummary> caseCommentList) {
        this.allCommentsList = caseCommentList;
        this.pagination.init(this.allCommentsList, this, this.PAGE_SIZE);
        if (caseCommentList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
    }

    @Override
    public Div getScrollBox() {
        return this.scrollbox;
    }

    @Override
    public void setVisibleItems(List visibleItems) {
        this.caseCommentList.setModel((Object)visibleItems);
        int pageSize = visibleItems.size();
        if (pageSize > 1) {
            ((CaseCommentItemView)this.comments.getComponent(pageSize - 1)).setLastElementStyle();
        }
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(@ForEvent(value={"click"}) Event e) {
        this.submitCommentAddition();
    }

    private void submitCommentAddition() {
        if (this.validateForm()) {
            ((CaseCommentsPresenter)this.presenter).addCaseComment(this.newCommentTextArea.getValue());
        }
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.newCommentTextArea.getValue());
        if (newCommentEmpty) {
            this.newCommentTextArea.focus();
            this.newCommentTextAreaHelp.setTextContent(this.translationService.format("CommentCannotBeEmpty", new Object[0]));
            this.newCommentTextAreaGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }

    @EventHandler(value={"sort-alpha-asc"})
    public void onSortAlphaAsc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortAlphaAsc, (HTMLElement)this.sortAlphaDesc, false);
    }

    @EventHandler(value={"sort-alpha-desc"})
    public void onSortAlphaDesc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortAlphaDesc, (HTMLElement)this.sortAlphaAsc, true);
    }

    private void onSortChange(HTMLElement toHide, HTMLElement toShow, Boolean sortByAsc) {
        DOMUtil.addCSSClass((HTMLElement)toHide, (String)"hidden");
        DOMUtil.removeCSSClass((HTMLElement)toShow, (String)"hidden");
        ((CaseCommentsPresenter)this.presenter).sortComments(sortByAsc);
    }
}

