/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.cdi;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Singleton;
import org.jbpm.shared.services.cdi.BootOnLoad;

public class BootOnLoadExtension
implements Extension {
    private final List<Bean<?>> startupBootstrapBeans = new LinkedList();

    public <X> void processBean(@Observes ProcessBean<X> event) {
        if (event.getAnnotated().isAnnotationPresent(BootOnLoad.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class))) {
            this.startupBootstrapBeans.add(event.getBean());
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.runPostConstruct(manager, this.startupBootstrapBeans);
    }

    private void runPostConstruct(BeanManager manager, List<Bean<?>> orderedBeans) {
        for (Bean<?> bean : orderedBeans) {
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
    }
}

