/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmJTATransactionManager
implements JbpmServicesTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(JbpmJTATransactionManager.class);
    private static final String[] KNOWN_UT_JNDI_KEYS = new String[]{"UserTransaction", "java:jboss/UserTransaction", System.getProperty("jbpm.ut.jndi.lookup")};
    private TransactionManager tm = new JtaTransactionManager((Object)this.findUserTransaction(), null, null);

    @Override
    public void attachPersistenceContext(EntityManager em) {
        em.joinTransaction();
    }

    @Override
    public boolean begin(EntityManager em) {
        int status = this.getStatus(em);
        boolean begun = false;
        if (status == 3 || status == 0 || status == 1) {
            begun = this.tm.begin();
        }
        return begun;
    }

    @Override
    public void commit(EntityManager em, boolean txOwner) {
        em.flush();
        this.tm.commit(txOwner);
    }

    @Override
    public void rollback(EntityManager em, boolean txOwner) {
        switch (this.tm.getStatus()) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                this.tm.rollback(txOwner);
            }
        }
    }

    @Override
    public int getStatus(EntityManager em) {
        return this.tm.getStatus();
    }

    @Override
    public void dispose() {
        this.tm = null;
    }

    protected UserTransaction findUserTransaction() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            return (UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ex) {
            for (String utLookup : KNOWN_UT_JNDI_KEYS) {
                if (utLookup == null) continue;
                try {
                    UserTransaction ut = (UserTransaction)context.lookup(utLookup);
                    return ut;
                }
                catch (NamingException e) {
                    logger.debug("User Transaction not found in JNDI under {}", (Object)utLookup);
                }
            }
            logger.warn("No user transaction found under known names");
            return null;
        }
    }

    @Override
    public void registerTXSynchronization(TransactionSynchronization txSync) {
        this.tm.registerTransactionSynchronization(txSync);
    }
}

