/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.persistence.api.OrderedTransactionSynchronization;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.TransactionSynchronization;
import org.jbpm.persistence.api.integration.EventManagerProvider;
import org.jbpm.persistence.timer.GlobalJpaTimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.core.timer.impl.TimerServiceListener;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.CacheManagerImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.error.DefaultExecutionErrorStorage;
import org.jbpm.runtime.manager.impl.error.ExecutionErrorManagerImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.jpa.TimerMappingInfo;
import org.jbpm.runtime.manager.impl.lock.RuntimeManagerLockStrategyFactory;
import org.jbpm.runtime.manager.impl.lock.RuntimeManagerLockWatcherSingletonService;
import org.jbpm.runtime.manager.impl.tx.NoOpTransactionManager;
import org.jbpm.runtime.manager.impl.tx.NoTransactionalTimerResourcesCleanupAwareSchedulerServiceInterceptor;
import org.jbpm.runtime.manager.impl.tx.TransactionAwareSchedulerServiceInterceptor;
import org.jbpm.runtime.manager.spi.RuntimeManagerLock;
import org.jbpm.runtime.manager.spi.RuntimeManagerLockStrategy;
import org.jbpm.services.task.events.WorkflowBridgeTaskLifeCycleEventListener;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.kie.internal.runtime.manager.CacheManager;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeEngine;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.SecurityManager;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeManager
implements InternalRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuntimeManager.class);
    protected RuntimeManagerRegistry registry = RuntimeManagerRegistry.get();
    protected RuntimeManagerLockStrategyFactory lockStrategyFactory = new RuntimeManagerLockStrategyFactory();
    protected org.kie.api.runtime.manager.RuntimeEnvironment environment;
    protected DeploymentDescriptor deploymentDescriptor;
    protected KieContainer kieContainer;
    protected CacheManager cacheManager = new CacheManagerImpl();
    protected boolean engineInitEager = Boolean.parseBoolean(System.getProperty("org.jbpm.rm.engine.eager", "false"));
    private static final String EMITTER_EAGER_PROP = "org.kie.jbpm.event.emitters.eagerInit";
    protected String identifier;
    protected boolean closed = false;
    protected SecurityManager securityManager = null;
    protected ExecutionErrorManager executionErrorManager;
    protected RuntimeManagerLockStrategy runtimeManagerLockStrategy;
    protected RuntimeManagerLockWatcherSingletonService watcher;

    public AbstractRuntimeManager(org.kie.api.runtime.manager.RuntimeEnvironment environment, String identifier) {
        ExecutionErrorStorage storage;
        this.environment = environment;
        this.identifier = identifier;
        if (this.registry.isRegistered(identifier)) {
            throw new IllegalStateException("RuntimeManager with id " + identifier + " is already active");
        }
        this.watcher = RuntimeManagerLockWatcherSingletonService.reference();
        ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("deploymentId", (Object)this.getIdentifier());
        this.internalSetDeploymentDescriptor();
        this.internalSetKieContainer();
        ((InternalRegisterableItemsFactory)environment.getRegisterableItemsFactory()).setRuntimeManager((InternalRuntimeManager)this);
        String eagerInit = (String)((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("RuntimeEngineEagerInit");
        if (eagerInit != null) {
            this.engineInitEager = Boolean.parseBoolean(eagerInit);
        }
        if (Boolean.getBoolean(EMITTER_EAGER_PROP)) {
            EventManagerProvider.getInstance();
        }
        if ((storage = (ExecutionErrorStorage)((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("ExecutionErrorStorage")) == null) {
            storage = new DefaultExecutionErrorStorage(environment.getEnvironment());
        }
        this.executionErrorManager = new ExecutionErrorManagerImpl(storage);
        ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("ExecutionErrorManager", (Object)this.executionErrorManager);
        logger.info("{} is created for {}", (Object)this.getClass().getSimpleName(), (Object)identifier);
    }

    private void internalSetDeploymentDescriptor() {
        this.deploymentDescriptor = (DeploymentDescriptor)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieDeploymentDescriptor");
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = new DeploymentDescriptorManager().getDefaultDescriptor();
        }
    }

    private void internalSetKieContainer() {
        this.kieContainer = (KieContainer)((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("KieContainer");
    }

    public void init() {
        this.runtimeManagerLockStrategy = !this.isUseLocking() ? this.lockStrategyFactory.createFreeLockStrategy() : this.lockStrategyFactory.createLockStrategy(this.identifier);
        this.initTimerService();
    }

    protected void initTimerService() {
        GlobalSchedulerService schedulerService;
        logger.trace("Initialize timer service for runtime {}", (Object)this.identifier);
        if (this.environment instanceof SchedulerProvider && (schedulerService = ((SchedulerProvider)this.environment).getSchedulerService()) != null) {
            GlobalTimerService globalTs = new GlobalTimerService((RuntimeManager)this, schedulerService);
            String timerServiceId = this.identifier + "-timerServiceId";
            TimerServiceRegistry.getInstance().registerTimerService(timerServiceId, (TimerService)globalTs);
            ((SimpleRuntimeEnvironment)this.environment).addToConfiguration("drools.timerService", "new org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate(\"" + timerServiceId + "\")");
            if (this.environment.usePersistence() && schedulerService.isTransactional()) {
                this.installPersistentTimerMapping((RuntimeManager)this, globalTs);
            }
            if (!schedulerService.isTransactional()) {
                schedulerService.setInterceptor((SchedulerServiceInterceptor)new TransactionAwareSchedulerServiceInterceptor(this.environment, (RuntimeManager)this, schedulerService));
            } else {
                schedulerService.setInterceptor((SchedulerServiceInterceptor)new NoTransactionalTimerResourcesCleanupAwareSchedulerServiceInterceptor(this.environment, (RuntimeManager)this, schedulerService));
            }
        }
    }

    private void installPersistentTimerMapping(final RuntimeManager manager, GlobalTimerService globalTs) {
        globalTs.addTimerServiceListener(new TimerServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fireTimerScheduled(JobHandle jobHandle) {
                if (jobHandle == null) {
                    return;
                }
                EntityManager em = AbstractRuntimeManager.this.getEntityManager(manager);
                if (em == null) {
                    return;
                }
                GlobalTimerService.GlobalJobHandle globalJobHandle = (GlobalTimerService.GlobalJobHandle)jobHandle;
                try {
                    if (!em.isJoinedToTransaction()) {
                        return;
                    }
                    List tmi = em.createQuery("SELECT o FROM TimerMappingInfo o WHERE o.kieSessionId = :kieSessionId AND o.uuid = :uuid", TimerMappingInfo.class).setParameter("kieSessionId", (Object)globalJobHandle.getSessionId()).setParameter("uuid", (Object)globalJobHandle.getUuid()).getResultList();
                    if (!tmi.isEmpty()) {
                        return;
                    }
                    GlobalJpaTimerJobInstance dtji = (GlobalJpaTimerJobInstance)globalJobHandle.getTimerJobInstance();
                    TimerMappingInfo info = new TimerMappingInfo(globalJobHandle.getId(), dtji.getExternalTimerId(), globalJobHandle.getSessionId(), globalJobHandle.getUuid());
                    em.persist((Object)info);
                    logger.debug("Created Timer Mapping Info for {}", (Object)info);
                }
                finally {
                    em.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fireTimerCancelled(JobHandle jobHandle) {
                if (jobHandle == null) {
                    return;
                }
                EntityManager em = AbstractRuntimeManager.this.getEntityManager(manager);
                if (em == null) {
                    return;
                }
                GlobalTimerService.GlobalJobHandle globalJobHandle = (GlobalTimerService.GlobalJobHandle)jobHandle;
                try {
                    if (!em.isJoinedToTransaction()) {
                        return;
                    }
                    int count = em.createQuery("DELETE FROM TimerMappingInfo o WHERE o.kieSessionId = :kieSessionId AND o.uuid = :uuid").setParameter("kieSessionId", (Object)globalJobHandle.getSessionId()).setParameter("uuid", (Object)globalJobHandle.getUuid()).executeUpdate();
                    logger.debug("Destroy Timer Mapping Info {} for id {} sessioin id {} and uuid {}", new Object[]{count, globalJobHandle.getId(), globalJobHandle.getSessionId(), globalJobHandle.getUuid()});
                }
                finally {
                    em.close();
                }
            }
        });
    }

    private EntityManager getEntityManager(RuntimeManager manager) {
        try {
            if (manager == null) {
                return null;
            }
            AbstractRuntimeManager arm = (AbstractRuntimeManager)manager;
            EntityManagerFactory emf = ((SimpleRuntimeEnvironment)arm.getEnvironment()).getEmf();
            if (emf != null) {
                return emf.createEntityManager();
            }
            emf = (EntityManagerFactory)arm.getEnvironment().getEnvironment().get("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emf != null) {
                return emf.createEntityManager();
            }
            String pu = ((InternalRuntimeManager)manager).getDeploymentDescriptor().getPersistenceUnit();
            emf = EntityManagerFactoryManager.get().getOrCreate(pu);
            return emf.createEntityManager();
        }
        catch (Throwable e) {
            logger.debug("could not create entity manager. more likely tx not active", e);
            return null;
        }
    }

    protected void registerItems(RuntimeEngine runtime) {
        RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
        KieSession ksession = ((InternalRuntimeEngine)runtime).internalGetKieSession();
        Map handlers = factory.getWorkItemHandlers(runtime);
        for (Map.Entry entry : handlers.entrySet()) {
            ksession.getWorkItemManager().registerWorkItemHandler((String)entry.getKey(), (WorkItemHandler)entry.getValue());
        }
        Map globals = factory.getGlobals(runtime);
        for (Map.Entry entry : globals.entrySet()) {
            ksession.setGlobal((String)entry.getKey(), entry.getValue());
        }
        List list = factory.getProcessEventListeners(runtime);
        for (Object listener : list) {
            ksession.addEventListener((ProcessEventListener)listener);
        }
        List list2 = factory.getAgendaEventListeners(runtime);
        for (AgendaEventListener listener : list2) {
            ksession.addEventListener(listener);
        }
        List wmListeners = factory.getRuleRuntimeEventListeners(runtime);
        for (RuleRuntimeEventListener listener : wmListeners) {
            ksession.addEventListener(listener);
        }
    }

    protected void registerDisposeCallback(RuntimeEngine runtime, TransactionSynchronization sync, Environment environment) {
        TransactionManager tm = this.getTransactionManager(environment);
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)((OrderedTransactionSynchronization)sync));
        }
    }

    protected boolean canDispose(RuntimeEngine runtime) {
        if (((RuntimeEngineImpl)runtime).isDisposed()) {
            return false;
        }
        if (((RuntimeEngineImpl)runtime).isAfterCompletion()) {
            return true;
        }
        try {
            TransactionManager tm = this.getTransactionManager(((InternalRuntimeEngine)runtime).internalGetKieSession().getEnvironment());
            if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                return false;
            }
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        return true;
    }

    protected void attachManager(RuntimeEngine runtime) {
        ((InternalRuntimeEngine)runtime).internalGetKieSession().getEnvironment().set("RuntimeManager", (Object)this);
        ((InternalRuntimeEngine)runtime).internalGetKieSession().getEnvironment().set("deploymentId", (Object)this.getIdentifier());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean removeJobs) {
        TimerService timerService;
        this.cacheManager.dispose();
        this.environment.close();
        this.registry.remove(this.identifier);
        if (this.watcher != null) {
            this.watcher.unreference();
            this.watcher = null;
        }
        if ((timerService = TimerServiceRegistry.getInstance().get(this.getIdentifier() + "-timerServiceId")) != null) {
            try {
                if (removeJobs && timerService instanceof GlobalTimerService) {
                    ((GlobalTimerService)timerService).destroy();
                }
                timerService.shutdown();
                GlobalSchedulerService schedulerService = ((SchedulerProvider)this.environment).getSchedulerService();
                if (schedulerService != null) {
                    schedulerService.shutdown();
                }
            }
            finally {
                TimerServiceRegistry.getInstance().remove(this.getIdentifier() + "-timerServiceId");
            }
        }
        this.closed = true;
    }

    public RuntimeEnvironment getEnvironment() {
        return (RuntimeEnvironment)this.environment;
    }

    public void setEnvironment(org.kie.api.runtime.manager.RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected InternalTaskService newTaskService(TaskServiceFactory factory) {
        InternalTaskService internalTaskService = (InternalTaskService)factory.newTaskService();
        if (internalTaskService instanceof CommandBasedTaskService) {
            ((CommandBasedTaskService)internalTaskService).getEnvironment().set("deploymentId", (Object)this.getIdentifier());
            ((CommandBasedTaskService)internalTaskService).getEnvironment().set("org.kie.api.marshalling.ObjectMarshallingStrategies", ((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("org.kie.api.marshalling.ObjectMarshallingStrategies"));
        }
        return internalTaskService;
    }

    protected void configureRuntimeOnTaskService(InternalTaskService internalTaskService, RuntimeEngine engine) {
        if (internalTaskService != null) {
            if (internalTaskService instanceof EventService) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)new ExternalTaskEventListener());
                ((EventService)internalTaskService).registerTaskEventListener((Object)new WorkflowBridgeTaskLifeCycleEventListener((RuntimeManager)this));
            }
            RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
            for (TaskLifeCycleEventListener taskListener : factory.getTaskListeners()) {
                ((EventService)internalTaskService).registerTaskEventListener((Object)taskListener);
            }
        }
    }

    protected void removeRuntimeFromTaskService() {
        TaskContentRegistry.get().removeMarshallerContext(this.getIdentifier());
    }

    public void softDispose(RuntimeEngine runtimeEngine) {
    }

    protected boolean canDestroy(RuntimeEngine runtime) {
        if (((RuntimeEngineImpl)runtime).isAfterCompletion()) {
            return false;
        }
        TransactionManager tm = this.getTransactionManager(runtime.getKieSession().getEnvironment());
        return tm.getStatus() == 3 || tm.getStatus() == 4;
    }

    protected boolean hasEnvironmentEntry(String name, Object value) {
        Object envEntry = this.environment.getEnvironment().get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }

    protected TransactionManager getTransactionManager(Environment env) {
        Object txm;
        if (env == null) {
            env = this.environment.getEnvironment();
        }
        if ((txm = env.get("org.kie.transaction.TransactionManager")) != null && txm instanceof TransactionManager) {
            return (TransactionManager)txm;
        }
        return TransactionManagerFactory.get().newTransactionManager(env);
    }

    protected TransactionManager getTransactionManagerInternal(Environment env) {
        try {
            return this.getTransactionManager(env);
        }
        catch (Exception e) {
            return new NoOpTransactionManager();
        }
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (this.securityManager != null) {
            throw new IllegalStateException("Security Manager for " + this.identifier + " manager is already set");
        }
        this.securityManager = securityManager;
    }

    public boolean hasSecurityManager() {
        return this.securityManager != null;
    }

    protected void checkPermission() {
        if (this.securityManager != null) {
            this.securityManager.checkPermission();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (cacheManager != null) {
            this.cacheManager = cacheManager;
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    protected boolean isUseLocking() {
        return false;
    }

    protected void createLockOnNewProcessInstance(Long id, RuntimeEngine runtime) {
        this.createLockOnGetEngine(id, runtime);
    }

    protected void createLockOnGetEngine(Context<?> context, RuntimeEngine runtime) {
        if (context instanceof ProcessInstanceIdContext) {
            Long piId = ((ProcessInstanceIdContext)context).getContextId();
            this.createLockOnGetEngine(piId, runtime);
        } else {
            logger.debug("Trying to release lock with a non proper context on runtime engine {}", (Object)runtime);
        }
    }

    protected void createLockOnGetEngine(Long id, RuntimeEngine runtime) {
        logger.debug("Attempt to lock {} on runtime {}", (Object)id, (Object)runtime);
        if (id == null) {
            return;
        }
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager engine {} disabled for id {}", (Object)runtime, (Object)id);
            return;
        }
        try {
            RuntimeManagerLock lock = this.runtimeManagerLockStrategy.lock(id, runtime);
            if (this.watcher != null) {
                this.watcher.watch(id, lock);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Runtime manager was not able to lock for {" + id + "}", e);
        }
    }

    protected void releaseAndCleanLock(RuntimeEngine runtime) {
        if (((RuntimeEngineImpl)runtime).getContext() instanceof ProcessInstanceIdContext) {
            Long piId = ((ProcessInstanceIdContext)((RuntimeEngineImpl)runtime).getContext()).getContextId();
            if (piId != null) {
                this.releaseAndCleanLock(piId, runtime);
            }
        } else {
            logger.debug("Trying to release lock with a non proper context onn runtime manager engine {}", (Object)runtime);
        }
    }

    protected void releaseAndCleanLock(Long id, RuntimeEngine runtime) {
        logger.debug("Attempt to unlock {} on runtime {}", (Object)id, (Object)runtime);
        if (id == null) {
            return;
        }
        if (!this.isUseLocking()) {
            logger.debug("Locking on runtime manager engine {} disabled for id {}", (Object)runtime, (Object)id);
            return;
        }
        if (this.watcher != null) {
            this.watcher.unwatch(id);
        }
        this.runtimeManagerLockStrategy.unlock(id, runtime);
    }

    protected boolean isActive() {
        return !this.hasEnvironmentEntry("Active", false);
    }

    public void activate() {
        ((SimpleRuntimeEnvironment)this.environment).addToEnvironment("Active", true);
    }

    public void deactivate() {
        ((SimpleRuntimeEnvironment)this.environment).addToEnvironment("Active", false);
    }

    public ExecutionErrorManager getExecutionErrorManager() {
        return this.executionErrorManager;
    }

    public abstract SessionFactory getFactory();
}

