/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.time.TimerService;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.tx.ExtendedJTATransactionManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;

public abstract class AbstractRuntimeManager
implements InternalRuntimeManager {
    protected static volatile List<String> activeManagers = new CopyOnWriteArrayList<String>();
    protected RuntimeEnvironment environment;
    protected String identifier;
    protected boolean closed = false;

    public AbstractRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.environment = environment;
        this.identifier = identifier;
        if (activeManagers.contains(identifier)) {
            throw new IllegalStateException("RuntimeManager with id " + identifier + " is already active");
        }
    }

    public abstract void init();

    protected void registerItems(RuntimeEngine runtime) {
        RegisterableItemsFactory factory = this.environment.getRegisterableItemsFactory();
        Map handlers = factory.getWorkItemHandlers(runtime);
        for (Map.Entry entry : handlers.entrySet()) {
            runtime.getKieSession().getWorkItemManager().registerWorkItemHandler((String)entry.getKey(), (WorkItemHandler)entry.getValue());
        }
        List processListeners = factory.getProcessEventListeners(runtime);
        for (ProcessEventListener listener : processListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
        List agendaListeners = factory.getAgendaEventListeners(runtime);
        for (AgendaEventListener listener : agendaListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
        List wmListeners = factory.getWorkingMemoryEventListeners(runtime);
        for (WorkingMemoryEventListener listener : wmListeners) {
            runtime.getKieSession().addEventListener(listener);
        }
    }

    protected void registerDisposeCallback(RuntimeEngine runtime, TransactionSynchronization sync) {
        ExtendedJTATransactionManager tm = new ExtendedJTATransactionManager(null, null, null);
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            tm.registerTransactionSynchronization(sync);
        }
    }

    protected void attachManager(RuntimeEngine runtime) {
        runtime.getKieSession().getEnvironment().set("RuntimeManager", (Object)this);
        runtime.getKieSession().getEnvironment().set("deploymentId", (Object)this.getIdentifier());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean removeJobs) {
        this.environment.close();
        activeManagers.remove(this.identifier);
        TimerService timerService = TimerServiceRegistry.getInstance().remove(this.getIdentifier() + "-timerServiceId");
        if (timerService != null) {
            if (removeJobs && timerService instanceof GlobalTimerService) {
                ((GlobalTimerService)timerService).destroy();
            }
            timerService.shutdown();
            GlobalSchedulerService schedulerService = ((SchedulerProvider)this.environment).getSchedulerService();
            if (schedulerService != null) {
                schedulerService.shutdown();
            }
        }
        this.closed = true;
    }

    public org.kie.internal.runtime.manager.RuntimeEnvironment getEnvironment() {
        return (org.kie.internal.runtime.manager.RuntimeEnvironment)this.environment;
    }

    public void setEnvironment(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void configureRuntimeOnTaskService(InternalTaskService internalTaskService) {
        if (internalTaskService != null) {
            internalTaskService.addMarshallerContext(this.getIdentifier(), new ContentMarshallerContext(this.environment.getEnvironment(), this.environment.getClassLoader()));
        }
    }

    protected void removeRuntimeFromTaskService(InternalTaskService internalTaskService) {
        if (internalTaskService != null) {
            internalTaskService.removeMarshallerContext(this.getIdentifier());
        }
    }

    protected boolean canDestroy() {
        ExtendedJTATransactionManager tm = new ExtendedJTATransactionManager(null, null, null);
        return tm.getStatus() == 3 || tm.getStatus() == 4;
    }
}

