/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.devservices;

import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.kogito.event.cloudevents.extension.ProcessMeta;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeWorkflowLogger
extends DefaultKogitoProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevModeWorkflowLogger.class);

    public void beforeProcessStarted(ProcessStartedEvent event) {
        LOGGER.info("Starting workflow '{}' ({})", (Object)event.getProcessInstance().getProcessId(), (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
        ((KogitoProcessInstance)event.getProcessInstance()).getVariables().forEach((name, value) -> LOGGER.info("Variable '{}' value: '{}'", name, value));
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        if (event.getProcessInstance().getState() != 2) {
            LOGGER.info("Workflow '{}' ({}) was started, now '{}'", new Object[]{event.getProcessInstance().getProcessId(), ((KogitoProcessInstance)event.getProcessInstance()).getStringId(), ProcessMeta.fromState((int)event.getProcessInstance().getState())});
        }
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.info("Workflow '{}' ({}) completed", (Object)event.getProcessInstance().getProcessId(), (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        String nodeName = event.getNodeInstance().getNodeName();
        LOGGER.info("Triggered node '{}' for process '{}' ({})", new Object[]{nodeName, event.getProcessInstance().getProcessId(), ((KogitoProcessInstance)event.getProcessInstance()).getStringId()});
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        LOGGER.info("Variable '{}' changed value from: '{}', to: '{}'", new Object[]{event.getVariableId(), event.getOldValue(), event.getNewValue()});
    }
}

