/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.core.process.incubation.quarkus.support;

import java.util.Map;
import java.util.Optional;
import org.kie.kogito.MappableToModel;
import org.kie.kogito.Model;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIdParser;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.SignalId;
import org.kie.kogito.incubation.processes.services.StatefulProcessService;
import org.kie.kogito.incubation.processes.services.contexts.ProcessMetaDataContext;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.process.Processes;

class StatefulProcessServiceImpl
implements StatefulProcessService {
    private final ProcessService svc;
    private final Processes processes;

    StatefulProcessServiceImpl(ProcessService svc, Processes processes) {
        this.svc = svc;
        this.processes = processes;
    }

    public ExtendedDataContext create(LocalId localId, DataContext inputContext) {
        LocalProcessId processId = (LocalProcessId)ProcessIdParser.select((LocalId)localId, LocalProcessId.class);
        ExtendedDataContext extendedDataContext = (ExtendedDataContext)inputContext.as(ExtendedDataContext.class);
        ProcessMetaDataContext inputMeta = (ProcessMetaDataContext)inputContext.as(ProcessMetaDataContext.class);
        Process<MappableToModel<Model>> process = this.parseProcess(processId);
        String businessKey = inputMeta.businessKey();
        Model model = this.toModel(extendedDataContext.data(), process);
        String startFromNodeId = inputMeta.startFrom();
        ProcessInstance instance = this.svc.createProcessInstance(process, businessKey, model, startFromNodeId);
        MapDataContext data = MapDataContext.from((Object)((Model)instance.variables()).toMap());
        ProcessMetaDataContext meta = ProcessMetaDataContext.of((LocalId)processId.instances().get(instance.id()));
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }

    public ExtendedDataContext signal(LocalId localId, DataContext dataContext) {
        SignalId signalId = (SignalId)ProcessIdParser.select((LocalId)localId, SignalId.class);
        Process<MappableToModel<Model>> process = this.parseProcess(signalId.processInstanceId().processId());
        Model m = (Model)this.svc.signalProcessInstance(process, signalId.processInstanceId().processInstanceId(), (Object)dataContext, signalId.signalId()).orElseThrow();
        MapDataContext data = MapDataContext.from((Object)m.toMap());
        ProcessMetaDataContext meta = ProcessMetaDataContext.of((LocalId)signalId.processInstanceId());
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }

    public ExtendedDataContext update(LocalId localId, DataContext dataContext) {
        ProcessInstanceId instanceId = (ProcessInstanceId)ProcessIdParser.select((LocalId)localId, ProcessInstanceId.class);
        Process<MappableToModel<Model>> process = this.parseProcess(instanceId.processId());
        MappableToModel model = (MappableToModel)this.toModel(dataContext, process);
        Optional optionalModel = this.svc.update(process, instanceId.processInstanceId(), model);
        Model m = (Model)optionalModel.orElseThrow();
        Map map = m.toMap();
        return ExtendedDataContext.ofData((DataContext)MapDataContext.from((Object)map));
    }

    public ExtendedDataContext abort(LocalId localId) {
        ProcessInstanceId processInstanceId = (ProcessInstanceId)ProcessIdParser.select((LocalId)localId, ProcessInstanceId.class);
        Process<MappableToModel<Model>> process = this.parseProcess(processInstanceId.processId());
        Model m = (Model)this.svc.delete(process, processInstanceId.processInstanceId()).orElseThrow();
        ProcessMetaDataContext meta = ProcessMetaDataContext.of((LocalId)localId);
        MapDataContext data = MapDataContext.of((Map)m.toMap());
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }

    public ExtendedDataContext get(LocalId localId) {
        ProcessInstanceId processInstanceId = (ProcessInstanceId)ProcessIdParser.select((LocalId)localId, ProcessInstanceId.class);
        Process<MappableToModel<Model>> process = this.parseProcess(processInstanceId.processId());
        Model m = (Model)this.svc.findById(process, processInstanceId.processInstanceId()).orElseThrow();
        ProcessMetaDataContext meta = ProcessMetaDataContext.of((LocalId)localId);
        MapDataContext data = MapDataContext.of((Map)m.toMap());
        return ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
    }

    private Process<MappableToModel<Model>> parseProcess(LocalProcessId processId) {
        return this.processes.processById(processId.processId());
    }

    private Model toModel(DataContext inputContext, Process<? extends Model> process) {
        MapDataContext mdc = (MapDataContext)inputContext.as(MapDataContext.class);
        Class<?> modelType = ((Model)process.createModel()).getClass();
        return (Model)InternalObjectMapper.objectMapper().convertValue((Object)mdc, modelType);
    }
}

