/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.quarkus.devui.runtime.rpc;

import io.quarkus.arc.profile.IfBuildProfile;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jbpm.quarkus.devui.runtime.forms.FormsStorage;
import org.jbpm.quarkus.devui.runtime.rpc.DataIndexCounter;
import org.jbpm.quarkus.devui.runtime.rpc.JBPMDevUIEventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProfile(value="dev")
public class JBPMDevuiJsonRPCService {
    private static final String DATA_INDEX_URL = "kogito.data-index.url";
    private static final Logger LOGGER = LoggerFactory.getLogger(JBPMDevuiJsonRPCService.class);
    public static final String PROCESS_INSTANCES = "ProcessInstances";
    public static final String USER_TASKS = "UserTaskInstances";
    public static final String JOBS = "Jobs";
    public static final String ALL_TASKS_IDS_QUERY = "{ \"operationName\": \"getAllTasksIds\", \"query\": \"query getAllTasksIds{  UserTaskInstances{ id } }\" }";
    public static final String ALL_PROCESS_INSTANCES_IDS_QUERY = "{ \"operationName\": \"getAllProcessesIds\", \"query\": \"query getAllProcessesIds{  ProcessInstances{ id } }\" }";
    public static final String ALL_JOBS_IDS_QUERY = "{ \"operationName\": \"getAllJobsIds\", \"query\": \"query getAllJobsIds{  Jobs{ id } }\" }";
    private WebClient dataIndexWebClient;
    private final Vertx vertx;
    private final JBPMDevUIEventPublisher eventPublisher;
    private final FormsStorage formsStorage;
    private DataIndexCounter processesCounter;
    private DataIndexCounter tasksCounter;
    private DataIndexCounter jobsCounter;

    @Inject
    public JBPMDevuiJsonRPCService(Vertx vertx, JBPMDevUIEventPublisher eventPublisher, FormsStorage formsStorage) {
        this.vertx = vertx;
        this.eventPublisher = eventPublisher;
        this.formsStorage = formsStorage;
    }

    @PostConstruct
    public void init() {
        Optional dataIndexURL = ConfigProvider.getConfig().getOptionalValue(DATA_INDEX_URL, String.class);
        dataIndexURL.ifPresent(this::initDataIndexWebClient);
    }

    private void initDataIndexWebClient(String dataIndexURL) {
        try {
            URL url = new URL(dataIndexURL);
            this.dataIndexWebClient = WebClient.create((Vertx)this.vertx, (WebClientOptions)this.buildWebClientOptions(url));
            String contextPath = url.getPath();
            this.processesCounter = new DataIndexCounter(ALL_PROCESS_INSTANCES_IDS_QUERY, PROCESS_INSTANCES, contextPath, this.vertx, this.dataIndexWebClient);
            this.tasksCounter = new DataIndexCounter(ALL_TASKS_IDS_QUERY, USER_TASKS, contextPath, this.vertx, this.dataIndexWebClient);
            this.jobsCounter = new DataIndexCounter(ALL_JOBS_IDS_QUERY, JOBS, contextPath, this.vertx, this.dataIndexWebClient);
            this.eventPublisher.setOnProcessEventListener(this.processesCounter::refresh);
            this.eventPublisher.setOnTaskEventListener(this.tasksCounter::refresh);
            this.eventPublisher.setOnJobEventListener(this.jobsCounter::refresh);
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot configure dataIndexWebClient with 'kogito.data-index.url'='{}':", (Object)dataIndexURL, (Object)ex);
        }
    }

    protected WebClientOptions buildWebClientOptions(URL dataIndexURL) throws MalformedURLException {
        return new WebClientOptions().setDefaultHost(dataIndexURL.getHost()).setDefaultPort(dataIndexURL.getPort() != -1 ? dataIndexURL.getPort() : dataIndexURL.getDefaultPort()).setSsl(dataIndexURL.getProtocol().compareToIgnoreCase("https") == 0);
    }

    public Multi<String> queryProcessInstancesCount() {
        return this.processesCounter.getMulti();
    }

    public Multi<String> queryTasksCount() {
        return this.tasksCounter.getMulti();
    }

    public Multi<String> queryJobsCount() {
        return this.jobsCounter.getMulti();
    }

    public Uni<String> getFormsCount() {
        return Uni.createFrom().item((Object)String.valueOf(this.formsStorage.getFormsCount()));
    }

    @PreDestroy
    public void destroy() {
        this.processesCounter.stop();
        this.tasksCounter.stop();
        this.jobsCounter.stop();
    }
}

