/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.quarkus.devui.runtime.rpc;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.MultiCacheOp;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIndexCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexCounter.class);
    private final Vertx vertx;
    private final MultiCacheOp<String> multi;
    private final WebClient dataIndexWebClient;
    private final String path;
    private final String query;
    private final String field;

    public DataIndexCounter(String query, String graphField, String path, Vertx vertx, WebClient dataIndexWebClient) {
        if (dataIndexWebClient == null) {
            throw new IllegalArgumentException("dataIndexWebClient is null");
        }
        this.query = query;
        this.field = graphField;
        this.path = path;
        this.vertx = vertx;
        this.dataIndexWebClient = dataIndexWebClient;
        this.multi = new MultiCacheOp((Multi)BroadcastProcessor.create());
        this.refreshCount();
    }

    public void refresh() {
        this.vertx.setTimer(1000L, id -> this.refreshCount());
    }

    public void stop() {
        this.multi.onComplete();
    }

    private void refreshCount() {
        LOGGER.debug("Refreshing data for query: {}", (Object)this.query);
        this.dataIndexWebClient.post(this.path + "/graphql").putHeader("content-type", "application/json").sendJson((Object)new JsonObject(this.query)).map(response -> {
            if (response.statusCode() == 200) {
                JsonObject responseData = response.bodyAsJsonObject().getJsonObject("data");
                return String.valueOf(responseData.getJsonArray(this.field).size());
            }
            return "0";
        }).onComplete(count -> this.multi.onNext((Object)((String)count.result())));
    }

    public Multi<String> getMulti() {
        return this.multi;
    }
}

