/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.quarkus.devui.runtime.forms.impl;

import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jbpm.quarkus.devui.runtime.forms.FormsStorage;
import org.jbpm.quarkus.devui.runtime.forms.model.Form;
import org.jbpm.quarkus.devui.runtime.forms.model.FormConfiguration;
import org.jbpm.quarkus.devui.runtime.forms.model.FormContent;
import org.jbpm.quarkus.devui.runtime.forms.model.FormFilter;
import org.jbpm.quarkus.devui.runtime.forms.model.FormInfo;
import org.jbpm.quarkus.devui.runtime.forms.model.FormResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FormsStorageImpl
implements FormsStorage {
    public static final String PROJECT_FORM_STORAGE_PROP = "quarkus.kogito-runtime-tools.forms.folder";
    private static final String CONFIG_EXT = ".config";
    private static final String FORMS_STORAGE_PATH = "/custom-forms-dev";
    private static final String JAR_FORMS_STORAGE_PATH = "/target/classes/custom-forms-dev";
    private static final String FS_FORMS_STORAGE_PATH = "/src/main/resources/custom-forms-dev";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsStorageImpl.class);
    private final Map<String, FormInfo> formInfoMap = new HashMap<String, FormInfo>();
    private final Map<String, Form> modifiedForms = new HashMap<String, Form>();
    private URL classLoaderFormsUrl;
    private URL formsStorageUrl;

    public FormsStorageImpl() {
        this.start(Thread.currentThread().getContextClassLoader().getResource(FORMS_STORAGE_PATH));
    }

    FormsStorageImpl(URL classLoaderFormsUrl) {
        this.start(classLoaderFormsUrl);
    }

    private void start(URL classLoaderFormsUrl) {
        this.start(classLoaderFormsUrl, this.getFormStorageUrl(classLoaderFormsUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(URL classLoaderFormsUrl, URL formsStorageUrl) {
        try {
            this.classLoaderFormsUrl = classLoaderFormsUrl;
            this.formsStorageUrl = formsStorageUrl;
        }
        catch (Exception ex) {
            LOGGER.warn("Couldn't properly initialize FormsStorageImpl");
        }
        finally {
            this.init();
        }
    }

    private URL getFormStorageUrl(URL classLoaderFormsUrl) {
        if (classLoaderFormsUrl == null) {
            return null;
        }
        String storageUrl = ConfigProvider.getConfig().getOptionalValue(PROJECT_FORM_STORAGE_PROP, String.class).orElseGet(() -> classLoaderFormsUrl.getFile().replace(JAR_FORMS_STORAGE_PATH, FS_FORMS_STORAGE_PATH));
        File formsStorageFolder = new File(storageUrl);
        if (!formsStorageFolder.exists() || !formsStorageFolder.isDirectory()) {
            LOGGER.warn("Cannot initialize form storage folder in path '" + formsStorageFolder.getPath() + "'");
        }
        try {
            return formsStorageFolder.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Cannot initialize form storage folder in path '" + formsStorageFolder.getPath() + "'", (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getFormsCount() {
        return this.formInfoMap.keySet().size();
    }

    @Override
    public Collection<FormInfo> getFormInfoList(FormFilter filter) {
        if (filter != null && !filter.getNames().isEmpty()) {
            return this.formInfoMap.entrySet().stream().filter(entry -> StringUtils.containsAnyIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence[])filter.getNames().toArray(new String[0]))).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return this.formInfoMap.values();
    }

    private FormInfo.FormType getFormType(String type) {
        switch (type) {
            case "html": {
                return FormInfo.FormType.HTML;
            }
            case "tsx": {
                return FormInfo.FormType.TSX;
            }
        }
        return null;
    }

    @Override
    public Form getFormContent(String formName) throws IOException {
        FormInfo formInfo = this.formInfoMap.get(formName);
        if (formInfo == null) {
            throw new RuntimeException("Cannot find form '" + formName + "'");
        }
        return this.modifiedForms.getOrDefault(formName, this.loadForm(formInfo));
    }

    private Form loadForm(FormInfo formInfo) throws IOException {
        File formFile = this.getFormFile(formInfo.getName(), formInfo);
        File formConfig = this.getFormConfigFile(formInfo.getName());
        String formConfiguration = "";
        if (formConfig != null && formConfig.exists()) {
            formConfiguration = IOUtils.toString((InputStream)new FileInputStream(formConfig), (Charset)StandardCharsets.UTF_8);
        }
        if (formFile == null || !formFile.exists()) {
            throw new FileNotFoundException(formInfo.getName() + "'s config file was not found");
        }
        Form form = new Form(formInfo, IOUtils.toString((InputStream)new FileInputStream(formFile), (Charset)StandardCharsets.UTF_8), this.readFormConfiguration(formConfiguration));
        return form;
    }

    private FormConfiguration readFormConfiguration(String configStr) {
        if (StringUtils.isEmpty((CharSequence)configStr)) {
            return new FormConfiguration("", new FormResources());
        }
        JsonObject configJSON = new JsonObject(configStr);
        FormResources resources = new FormResources();
        JsonObject resourcesJSON = configJSON.getJsonObject("resources");
        resourcesJSON.getJsonObject("scripts").stream().forEach(entry -> resources.getScripts().put((String)entry.getKey(), entry.getValue().toString()));
        resourcesJSON.getJsonObject("styles").stream().forEach(entry -> resources.getStyles().put((String)entry.getKey(), entry.getValue().toString()));
        return new FormConfiguration(configJSON.getString("schema"), resources);
    }

    private File getFormFile(String formName, FormInfo formInfo) throws MalformedURLException {
        URL formUrl = new URL(this.classLoaderFormsUrl.toString() + File.separator + formName + "." + formInfo.getType().getValue());
        return FileUtils.toFile((URL)formUrl);
    }

    private File getFormConfigFile(String formName) throws MalformedURLException {
        URL configUri = new URL(this.classLoaderFormsUrl.toString() + File.separator + formName + CONFIG_EXT);
        return FileUtils.toFile((URL)configUri);
    }

    @Override
    public void updateFormContent(String formName, FormContent formContent) throws IOException {
        if (this.formsStorageUrl == null) {
            throw new RuntimeException("Cannot store form'" + formName + "'. Form storage couldnt be properly initialized.");
        }
        FormInfo formInfo = this.formInfoMap.get(formName);
        if (formInfo == null) {
            throw new RuntimeException("Cannot find form '" + formName + "'");
        }
        if (formContent == null) {
            throw new RuntimeException("Invalid form content");
        }
        File formFile = this.getPersistableFormFile(formInfo);
        File configFile = this.getPersistableConfigFile(formInfo);
        if (!formFile.exists() || !configFile.exists()) {
            throw new RuntimeException("Cannot store form '" + formName + "'. Unable to find form");
        }
        FileUtils.write((File)formFile, (CharSequence)formContent.getSource(), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)configFile, (CharSequence)JsonObject.mapFrom((Object)formContent.getConfiguration()).encodePrettily(), (Charset)StandardCharsets.UTF_8);
        LocalDateTime lastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), TimeZone.getDefault().toZoneId());
        FormInfo newInfo = new FormInfo(formName, formInfo.getType(), lastModified);
        this.formInfoMap.put(formName, newInfo);
        this.modifiedForms.put(formName, new Form(newInfo, formContent.getSource(), formContent.getConfiguration()));
    }

    private File getPersistableFormFile(FormInfo formInfo) {
        return FileUtils.getFile((String[])new String[]{this.formsStorageUrl.getFile() + "/" + formInfo.getName() + "." + formInfo.getType().getValue()});
    }

    private File getPersistableConfigFile(FormInfo formInfo) {
        return FileUtils.getFile((String[])new String[]{this.formsStorageUrl.getFile() + "/" + formInfo.getName() + CONFIG_EXT});
    }

    private void init() {
        this.readFormResources().stream().filter(file -> this.hasConfigFile(FilenameUtils.removeExtension((String)file.getName()))).forEach(file -> {
            LocalDateTime lastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), TimeZone.getDefault().toZoneId());
            this.formInfoMap.put(FilenameUtils.removeExtension((String)file.getName()), new FormInfo(FilenameUtils.removeExtension((String)file.getName()), this.getFormType(FilenameUtils.getExtension((String)file.getName())), lastModified));
        });
    }

    private Collection<File> readFormResources() {
        if (this.classLoaderFormsUrl != null) {
            LOGGER.info("form's files path is {}", (Object)this.classLoaderFormsUrl.toString());
            File rootFolder = FileUtils.toFile((URL)this.classLoaderFormsUrl);
            return FileUtils.listFiles((File)rootFolder, (String[])new String[]{"html", "tsx"}, (boolean)false);
        }
        return Collections.emptyList();
    }

    private boolean hasConfigFile(String formName) {
        try {
            return this.getFormConfigFile(formName).exists();
        }
        catch (MalformedURLException e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }
}

