/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.quarkus.devui.runtime.forms;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import org.jbpm.quarkus.devui.runtime.forms.FormsStorage;
import org.jbpm.quarkus.devui.runtime.forms.model.FormContent;
import org.jbpm.quarkus.devui.runtime.forms.model.FormFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/forms")
public class FormsService {
    private FormsStorage storage;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormsService.class);

    @Inject
    public FormsService(FormsStorage storage) {
        this.storage = storage;
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getFormsList(@QueryParam(value="names") FormFilter filter) {
        try {
            return Response.ok(this.storage.getFormInfoList(filter)).build();
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting forms list: ", (Throwable)e);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting forms list: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/count")
    @Produces(value={"text/plain"})
    public Response formsCount() {
        try {
            return Response.ok((Object)this.storage.getFormsCount()).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while getting forms count: ", (Throwable)e);
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting forms count: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/{formName:\\S+}/")
    @Produces(value={"application/json"})
    public Response getFormContent(@PathParam(value="formName") String formName) {
        try {
            Response.ResponseBuilder responseBuilder = Response.ok((Object)this.storage.getFormContent(formName));
            return responseBuilder.build();
        }
        catch (FileNotFoundException fe) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)fe.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.warn("Coudln't find form '" + formName + "'");
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Unexpected error while getting form content: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/{formName:\\S+}/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateFormContent(@PathParam(value="formName") String formName, FormContent formContent) {
        try {
            this.storage.updateFormContent(formName, formContent);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)e.getMessage()).build();
        }
    }
}

