/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.subtask;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.SubTasksStrategy;

@Decorator
public class SubTaskDecorator
implements TaskInstanceService {
    @Inject
    @Delegate
    private TaskInstanceService instanceService;
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private TaskQueryService queryService;

    public void setInstanceService(TaskInstanceService instanceService) {
        this.instanceService = instanceService;
    }

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void setQueryService(TaskQueryService queryService) {
        this.queryService = queryService;
    }

    public long addTask(Task task, Map<String, Object> params) {
        return this.instanceService.addTask(task, params);
    }

    public long addTask(Task task, ContentData data) {
        return this.instanceService.addTask(task, data);
    }

    public void activate(long taskId, String userId) {
        this.instanceService.activate(taskId, userId);
    }

    public void claim(long taskId, String userId) {
        this.instanceService.claim(taskId, userId);
    }

    public void claim(long taskId, String userId, List<String> groupIds) {
        this.instanceService.claim(taskId, userId, groupIds);
    }

    public void claimNextAvailable(String userId, String language) {
        this.instanceService.claimNextAvailable(userId, language);
    }

    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.instanceService.claimNextAvailable(userId, groupIds, language);
    }

    public void complete(long taskId, String userId, Map<String, Object> data) {
        this.checkSubTaskStrategies(taskId, userId, data);
        this.instanceService.complete(taskId, userId, data);
    }

    public void delegate(long taskId, String userId, String targetUserId) {
        this.instanceService.delegate(taskId, userId, targetUserId);
    }

    public void deleteFault(long taskId, String userId) {
        this.instanceService.deleteFault(taskId, userId);
    }

    public void deleteOutput(long taskId, String userId) {
        this.instanceService.deleteOutput(taskId, userId);
    }

    public void exit(long taskId, String userId) {
        this.instanceService.exit(taskId, userId);
    }

    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        this.instanceService.fail(taskId, userId, faultData);
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        this.instanceService.forward(taskId, userId, targetEntityId);
    }

    public void release(long taskId, String userId) {
        this.instanceService.release(taskId, userId);
    }

    public void remove(long taskId, String userId) {
        this.instanceService.remove(taskId, userId);
    }

    public void resume(long taskId, String userId) {
        this.instanceService.resume(taskId, userId);
    }

    public void setFault(long taskId, String userId, FaultData fault) {
        this.instanceService.setFault(taskId, userId, fault);
    }

    public void setOutput(long taskId, String userId, Object outputContentData) {
        this.instanceService.setOutput(taskId, userId, outputContentData);
    }

    public void setPriority(long taskId, int priority) {
        this.instanceService.setPriority(taskId, priority);
    }

    public void skip(long taskId, String userId) {
        this.instanceService.skip(taskId, userId);
        this.checkSubTaskStrategies(taskId, userId, null);
    }

    public void start(long taskId, String userId) {
        this.instanceService.start(taskId, userId);
    }

    public void stop(long taskId, String userId) {
        this.instanceService.stop(taskId, userId);
    }

    public void suspend(long taskId, String userId) {
        this.instanceService.suspend(taskId, userId);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.instanceService.nominate(taskId, userId, potentialOwners);
    }

    private void checkSubTaskStrategies(long taskId, String userId, Map<String, Object> data) {
        List subTasks;
        Task task = this.queryService.getTaskInstanceById(taskId);
        Task parentTask = null;
        if (task.getTaskData().getParentId() != -1L) {
            parentTask = (Task)this.pm.find(TaskImpl.class, (Object)task.getTaskData().getParentId());
        }
        if (parentTask != null && ((InternalTask)parentTask).getSubTaskStrategy().equals((Object)SubTasksStrategy.EndParentOnAllSubTasksEnd) && ((subTasks = this.queryService.getSubTasksByParent(parentTask.getId().longValue())).isEmpty() || subTasks.size() == 1 && ((TaskSummary)subTasks.get(0)).getId() == taskId)) {
            this.complete(parentTask.getId(), "Administrator", data);
        }
        if (((InternalTask)task).getSubTaskStrategy().equals((Object)SubTasksStrategy.SkipAllSubTasksOnParentSkip)) {
            subTasks = this.queryService.getSubTasksByParent(task.getId().longValue());
            for (TaskSummary taskSummary : subTasks) {
                Task subTask = this.queryService.getTaskInstanceById(taskSummary.getId());
                this.skip(subTask.getId(), "Administrator");
            }
        }
    }

    public void setExpirationDate(long taskId, Date date) {
        this.instanceService.setExpirationDate(taskId, date);
    }

    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        this.instanceService.setDescriptions(taskId, descriptions);
    }

    public void setSkipable(long taskId, boolean skipable) {
        this.instanceService.setSkipable(taskId, skipable);
    }

    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        this.instanceService.setSubTaskStrategy(taskId, strategy);
    }

    public int getPriority(long taskId) {
        return this.instanceService.getPriority(taskId);
    }

    public Date getExpirationDate(long taskId) {
        return this.instanceService.getExpirationDate(taskId);
    }

    public List<I18NText> getDescriptions(long taskId) {
        return this.instanceService.getDescriptions(taskId);
    }

    public boolean isSkipable(long taskId) {
        return this.instanceService.isSkipable(taskId);
    }

    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return this.instanceService.getSubTaskStrategy(taskId);
    }

    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        this.instanceService.setTaskNames(taskId, taskNames);
    }
}

