/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskClaimedEvent;
import org.jbpm.services.task.events.BeforeTaskClaimedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
public class ClaimTaskCommand
extends TaskCommand<Void> {
    public ClaimTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskClaimedEvent>(){}}).fire((Object)task);
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        if (!potOwnerAllowed && !adminAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.Reserved);
            ((InternalTaskData)task.getTaskData()).setActualOwner(user);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskClaimedEvent>(){}}).fire((Object)task);
        return null;
    }
}

