/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.internals.lifecycle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.FaultData;
import org.jbpm.task.Group;
import org.jbpm.task.Operation;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.annotations.Internal;
import org.jbpm.task.annotations.Mvel;
import org.jbpm.task.api.TaskContentService;
import org.jbpm.task.api.TaskDefService;
import org.jbpm.task.api.TaskIdentityService;
import org.jbpm.task.api.TaskQueryService;
import org.jbpm.task.events.AfterTaskActivatedEvent;
import org.jbpm.task.events.AfterTaskClaimedEvent;
import org.jbpm.task.events.AfterTaskCompletedEvent;
import org.jbpm.task.events.AfterTaskDelegatedEvent;
import org.jbpm.task.events.AfterTaskExitedEvent;
import org.jbpm.task.events.AfterTaskFailedEvent;
import org.jbpm.task.events.AfterTaskForwardedEvent;
import org.jbpm.task.events.AfterTaskReleasedEvent;
import org.jbpm.task.events.AfterTaskResumedEvent;
import org.jbpm.task.events.AfterTaskSkippedEvent;
import org.jbpm.task.events.AfterTaskStartedEvent;
import org.jbpm.task.events.AfterTaskSuspendedEvent;
import org.jbpm.task.events.BeforeTaskActivatedEvent;
import org.jbpm.task.events.BeforeTaskClaimedEvent;
import org.jbpm.task.events.BeforeTaskCompletedEvent;
import org.jbpm.task.events.BeforeTaskDelegatedEvent;
import org.jbpm.task.events.BeforeTaskExitedEvent;
import org.jbpm.task.events.BeforeTaskFailedEvent;
import org.jbpm.task.events.BeforeTaskForwardedEvent;
import org.jbpm.task.events.BeforeTaskReleasedEvent;
import org.jbpm.task.events.BeforeTaskResumedEvent;
import org.jbpm.task.events.BeforeTaskSkippedEvent;
import org.jbpm.task.events.BeforeTaskStartedEvent;
import org.jbpm.task.events.BeforeTaskStoppedEvent;
import org.jbpm.task.events.BeforeTaskSuspendedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.exception.TaskException;
import org.jbpm.task.internals.lifecycle.Allowed;
import org.jbpm.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.task.internals.lifecycle.OperationCommand;
import org.jbpm.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;

@Mvel
@ApplicationScoped
@Transactional
public class MVELLifeCycleManager
implements LifeCycleManager {
    @Inject
    private EntityManager em;
    @Inject
    private TaskDefService taskDefService;
    @Inject
    private TaskQueryService taskQueryService;
    @Inject
    private TaskIdentityService taskIdentityService;
    @Inject
    private TaskContentService taskContentService;
    @Inject
    private Event<Task> taskEvents;
    @Inject
    @Internal
    private TaskLifeCycleEventListener eventListener;
    private Map<Operation, List<OperationCommand>> operations;
    @Inject
    private Logger logger;

    public MVELLifeCycleManager() {
    }

    public MVELLifeCycleManager(TaskDefService taskDefService, TaskQueryService taskQueryService, TaskIdentityService taskIdentityService, TaskLifeCycleEventListener eventListener) {
        this.taskDefService = taskDefService;
        this.taskQueryService = taskQueryService;
        this.taskIdentityService = taskIdentityService;
        this.eventListener = eventListener;
    }

    void evalCommand(Operation operation, List<OperationCommand> commands, Task task, User user, OrganizationalEntity targetEntity, List<String> groupIds) throws PermissionDeniedException {
        boolean statusMatched = false;
        TaskData taskData = task.getTaskData();
        for (OperationCommand command : commands) {
            if (command.getStatus() != null) {
                for (Status status : command.getStatus()) {
                    if (task.getTaskData().getStatus() == status) {
                        statusMatched = true;
                        if (!this.isAllowed(command, task, user, groupIds)) {
                            String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                            throw new PermissionDeniedException(errorMessage);
                        }
                        this.commands(command, task, user, targetEntity);
                        continue;
                    }
                    this.logger.log(Level.FINEST, "No match on status for task " + task.getId() + ": status " + (Object)((Object)task.getTaskData().getStatus()) + " != " + (Object)((Object)status));
                }
            }
            if (command.getPreviousStatus() == null) continue;
            for (Status status : command.getPreviousStatus()) {
                if (taskData.getPreviousStatus() == status) {
                    statusMatched = true;
                    if (!this.isAllowed(command, task, user, groupIds)) {
                        String errorMessage = "User '" + user + "' does not have permissions to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId();
                        throw new PermissionDeniedException(errorMessage);
                    }
                    this.commands(command, task, user, targetEntity);
                    continue;
                }
                this.logger.log(Level.FINEST, "No match on previous status for task " + task.getId() + ": status " + (Object)((Object)task.getTaskData().getStatus()) + " != " + (Object)((Object)status));
            }
        }
        if (!statusMatched) {
            String errorMessage = "User '" + user + "' was unable to execution operation '" + (Object)((Object)operation) + "' on task id " + task.getId() + " due to a no 'current status' match";
            throw new PermissionDeniedException(errorMessage);
        }
    }

    private boolean isAllowed(OperationCommand command, Task task, User user, List<String> groupIds) {
        boolean operationAllowed = false;
        for (Allowed allowed : command.getAllowed()) {
            if (operationAllowed) break;
            switch (allowed) {
                case Owner: {
                    operationAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
                    break;
                }
                case Initiator: {
                    operationAllowed = task.getTaskData().getCreatedBy() != null && task.getTaskData().getCreatedBy().equals(user) || groupIds != null && groupIds.contains(task.getTaskData().getCreatedBy().getId());
                    break;
                }
                case PotentialOwner: {
                    operationAllowed = this.isAllowed(user, groupIds, task.getPeopleAssignments().getPotentialOwners());
                    break;
                }
                case BusinessAdministrator: {
                    operationAllowed = this.isAllowed(user, groupIds, task.getPeopleAssignments().getBusinessAdministrators());
                    break;
                }
                case Anyone: {
                    operationAllowed = true;
                }
            }
        }
        if (operationAllowed && command.isUserIsExplicitPotentialOwner()) {
            operationAllowed = task.getPeopleAssignments().getPotentialOwners().contains(user);
        }
        if (operationAllowed && command.isSkipable()) {
            operationAllowed = task.getTaskData().isSkipable();
        }
        return operationAllowed;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void commands(OperationCommand command, Task task, User user, OrganizationalEntity targetEntity) {
        PeopleAssignments people = task.getPeopleAssignments();
        TaskData taskData = task.getTaskData();
        if (command.getNewStatus() != null) {
            taskData.setStatus(command.getNewStatus());
        } else if (command.isSetToPreviousStatus()) {
            taskData.setStatus(taskData.getPreviousStatus());
        }
        if (command.isAddTargetEntityToPotentialOwners() && !people.getPotentialOwners().contains(targetEntity)) {
            people.getPotentialOwners().add(targetEntity);
        }
        if (command.isRemoveUserFromPotentialOwners()) {
            people.getPotentialOwners().remove(user);
        }
        if (command.isSetNewOwnerToUser()) {
            taskData.setActualOwner(user);
        }
        if (command.isSetNewOwnerToNull()) {
            taskData.setActualOwner(null);
        }
        if (command.getExec() != null) {
            switch (command.getExec()) {
                case Claim: {
                    taskData.setActualOwner((User)targetEntity);
                }
            }
        }
    }

    @Override
    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, Map<String, Object> data, List<String> groupIds) throws TaskException {
        List<OperationCommand> commands = this.operations.get((Object)operation);
        Task task = this.taskQueryService.getTaskInstanceById(taskId);
        User user = this.taskIdentityService.getUserById(userId);
        OrganizationalEntity targetEntity = null;
        if (targetEntityId != null && !targetEntityId.equals("")) {
            targetEntity = this.taskIdentityService.getOrganizationalEntityById(targetEntityId);
        }
        switch (operation) {
            case Activate: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskActivatedEvent>(){}}).fire((Object)task);
                break;
            }
            case Claim: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskClaimedEvent>(){}}).fire((Object)task);
                break;
            }
            case Complete: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskCompletedEvent>(){}}).fire((Object)task);
                break;
            }
            case Delegate: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskDelegatedEvent>(){}}).fire((Object)task);
                break;
            }
            case Exit: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskExitedEvent>(){}}).fire((Object)task);
                break;
            }
            case Fail: {
                if (data != null) {
                    FaultData faultData = ContentMarshallerHelper.marshalFault(data, null);
                    Content content = new Content();
                    content.setContent(faultData.getContent());
                    this.em.persist((Object)content);
                    task.getTaskData().setFault(content.getId(), faultData);
                }
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskFailedEvent>(){}}).fire((Object)task);
                break;
            }
            case Forward: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskForwardedEvent>(){}}).fire((Object)task);
                break;
            }
            case Release: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskReleasedEvent>(){}}).fire((Object)task);
                break;
            }
            case Resume: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskResumedEvent>(){}}).fire((Object)task);
                break;
            }
            case Skip: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskSkippedEvent>(){}}).fire((Object)task);
                break;
            }
            case Start: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskStartedEvent>(){}}).fire((Object)task);
                break;
            }
            case Stop: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskStoppedEvent>(){}}).fire((Object)task);
                break;
            }
            case Suspend: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<BeforeTaskSuspendedEvent>(){}}).fire((Object)task);
            }
        }
        this.evalCommand(operation, commands, task, user, targetEntity, groupIds);
        switch (operation) {
            case Activate: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskActivatedEvent>(){}}).fire((Object)task);
                break;
            }
            case Claim: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskClaimedEvent>(){}}).fire((Object)task);
                break;
            }
            case Complete: {
                if (data != null) {
                    this.taskContentService.addContent(taskId, data);
                }
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskCompletedEvent>(){}}).fire((Object)task);
                break;
            }
            case Delegate: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskDelegatedEvent>(){}}).fire((Object)task);
                task.getTaskData().setStatus(Status.Reserved);
            }
            case Exit: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskExitedEvent>(){}}).fire((Object)task);
                break;
            }
            case Fail: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskFailedEvent>(){}}).fire((Object)task);
                break;
            }
            case Forward: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskForwardedEvent>(){}}).fire((Object)task);
                break;
            }
            case Release: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskReleasedEvent>(){}}).fire((Object)task);
                break;
            }
            case Resume: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskResumedEvent>(){}}).fire((Object)task);
                break;
            }
            case Start: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskStartedEvent>(){}}).fire((Object)task);
                break;
            }
            case Skip: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskSkippedEvent>(){}}).fire((Object)task);
                break;
            }
            case Stop: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskSuspendedEvent>(){}}).fire((Object)task);
                break;
            }
            case Suspend: {
                this.taskEvents.select(new Annotation[]{new AnnotationLiteral<AfterTaskSuspendedEvent>(){}}).fire((Object)task);
            }
        }
    }

    @PostConstruct
    public void initMVELOperations() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        InputStream is = null;
        is = this.getClass().getResourceAsStream("/operations-dsl.mvel");
        if (is == null) {
            throw new RuntimeException("Unable To initialise TaskService, could not find Operations DSL");
        }
        InputStreamReader reader = new InputStreamReader(is);
        try {
            this.operations = (Map)MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable To initialise TaskService, could not load Operations DSL");
        }
    }

    public static String toString(Reader reader) throws IOException {
        int charValue;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public static Object eval(Reader reader) {
        try {
            return MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(Reader reader, Map<String, Object> vars) {
        try {
            return MVELLifeCycleManager.eval(MVELLifeCycleManager.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    public static Object eval(String str, Map<String, Object> vars) {
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addPackageImport("org.jbpm.task");
        pconf.addPackageImport("org.jbpm.task.query");
        pconf.addPackageImport("org.jbpm.task.internals.lifecycle");
        pconf.addImport(Status.class);
        pconf.addImport(Allowed.class);
        pconf.addPackageImport("java.util");
        ParserContext context = new ParserContext(pconf);
        Serializable s = MVEL.compileExpression((String)str.trim(), (ParserContext)context);
        if (vars != null) {
            return MVEL.executeExpression((Object)s, vars);
        }
        return MVEL.executeExpression((Object)s);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        Task task = (Task)this.em.find(Task.class, (Object)taskId);
        User user = (User)this.em.find(User.class, (Object)userId);
        if (this.isAllowed(user, null, task.getPeopleAssignments().getBusinessAdministrators())) {
            task.getTaskData().assignOwnerAndStatus(potentialOwners);
            if (task.getTaskData().getStatus() == Status.Ready) {
                task.getPeopleAssignments().setPotentialOwners(potentialOwners);
            }
        } else {
            throw new PermissionDeniedException("User " + userId + " is not allowed to perform Nominate on Task " + taskId);
        }
    }
}

