/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.drools.core.util.StringUtils;
import org.jbpm.task.Group;
import org.jbpm.task.Operation;
import org.jbpm.task.User;
import org.jbpm.task.annotations.Mvel;
import org.jbpm.task.exception.TaskException;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.internals.lifecycle.LifeCycleManager;

@Decorator
public abstract class UserGroupLifeCycleManagerDecorator
implements LifeCycleManager {
    @Inject
    @Delegate
    @Mvel
    private LifeCycleManager manager;
    @Inject
    private EntityManager em;
    @Inject
    private UserGroupCallback userGroupCallback;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();

    @Override
    public void taskOperation(Operation operation, long taskId, String userId, String targetEntityId, Map<String, Object> data, List<String> groupIds) throws TaskException {
        groupIds = this.doUserGroupCallbackOperation(userId, groupIds);
        this.doCallbackUserOperation(targetEntityId);
        this.manager.taskOperation(operation, taskId, userId, targetEntityId, data, groupIds);
    }

    private List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        this.doCallbackUserOperation(userId);
        this.doCallbackGroupsOperation(userId, groupIds);
        return this.userGroupCallback.getGroupsForUser(userId, groupIds, null);
    }

    private boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    private boolean doCallbackGroupOperation(String groupId) {
        if (groupId != null && this.userGroupCallback.existsGroup(groupId)) {
            this.addGroupFromCallbackOperation(groupId);
            return true;
        }
        return false;
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.em.find(User.class, (Object)userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.em.persist((Object)user);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        block6: {
            block4: {
                List<String> userGroups;
                block5: {
                    if (userId == null) break block4;
                    if (groupIds == null || groupIds.size() <= 0) break block5;
                    List<String> userGroups2 = this.userGroupCallback.getGroupsForUser(userId, groupIds, null);
                    for (String groupId : groupIds) {
                        if (!this.userGroupCallback.existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                    break block6;
                }
                if (this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = this.userGroupCallback.getGroupsForUser(userId, null, null)) == null || userGroups.size() <= 0) break block6;
                for (String group : userGroups) {
                    this.addGroupFromCallbackOperation(group);
                }
                this.userGroupsMap.put(userId, true);
                break block6;
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        }
    }

    private void addGroupFromCallbackOperation(String groupId) {
        try {
            boolean groupExists;
            boolean bl = groupExists = this.em.find(Group.class, (Object)groupId) != null;
            if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
                Group group = new Group(groupId);
                this.em.persist((Object)group);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

