/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskCompletedEvent;
import org.jbpm.task.events.BeforeTaskCompletedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.kie.command.Context;

@Transactional
public class CompleteTaskCommand<Void>
extends TaskCommand {
    private Map<String, Object> data;

    public CompleteTaskCommand(long taskId, String userId, Map<String, Object> data) {
        this.taskId = taskId;
        this.userId = userId;
        this.data = data;
    }

    public Void execute(Context cntxt) {
        boolean operationAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskCompletedEvent>(){}}).fire((Object)task);
        boolean bl = operationAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!operationAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            task.getTaskData().setStatus(Status.Completed);
        }
        if (this.data != null) {
            context.getTaskContentService().addContent(this.taskId, this.data);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskCompletedEvent>(){}}).fire((Object)task);
        return null;
    }
}

