/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.jbpm.task.Deadline;
import org.jbpm.task.utils.CollectionUtils;

@Embeddable
public class Deadlines
implements Externalizable {
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Deadlines_StartDeadLine_Id", nullable=true)
    private List<Deadline> startDeadlines = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Deadlines_EndDeadLine_Id", nullable=true)
    private List<Deadline> endDeadlines = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        CollectionUtils.writeDeadlineList(this.startDeadlines, out);
        CollectionUtils.writeDeadlineList(this.endDeadlines, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startDeadlines = CollectionUtils.readDeadlinesList(in);
        this.endDeadlines = CollectionUtils.readDeadlinesList(in);
    }

    public List<Deadline> getStartDeadlines() {
        return this.startDeadlines;
    }

    public void setStartDeadlines(List<Deadline> startDeadlines) {
        this.startDeadlines = startDeadlines;
    }

    public List<Deadline> getEndDeadlines() {
        return this.endDeadlines;
    }

    public void setEndDeadlines(List<Deadline> endDeadlines) {
        this.endDeadlines = endDeadlines;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionUtils.hashCode(this.endDeadlines);
        result = 31 * result + CollectionUtils.hashCode(this.startDeadlines);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deadlines)) {
            return false;
        }
        Deadlines other = (Deadlines)obj;
        return CollectionUtils.equals(this.endDeadlines, other.endDeadlines) && CollectionUtils.equals(this.startDeadlines, other.startDeadlines);
    }
}

