/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.util.List;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.drools.core.util.StringUtils;
import org.jbpm.task.Comment;
import org.jbpm.task.User;
import org.jbpm.task.api.TaskCommentService;
import org.jbpm.task.identity.UserGroupCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Decorator
public class UserGroupTaskCommentDecorator
implements TaskCommentService {
    @Inject
    @Delegate
    private TaskCommentService commentService;
    @Inject
    private UserGroupCallback userGroupCallback;
    @Inject
    private EntityManager em;

    @Override
    public long addComment(long taskId, Comment comment) {
        this.doCallbackOperationForComment(comment);
        long commentId = this.commentService.addComment(taskId, comment);
        return commentId;
    }

    @Override
    public void deleteComment(long taskId, long commentId) {
        this.commentService.deleteComment(taskId, commentId);
    }

    @Override
    public List<Comment> getAllCommentsByTaskId(long taskId) {
        return this.commentService.getAllCommentsByTaskId(taskId);
    }

    @Override
    public Comment getCommentById(long commentId) {
        return this.commentService.getCommentById(commentId);
    }

    private void doCallbackOperationForComment(Comment comment) {
        if (comment != null && comment.getAddedBy() != null) {
            this.doCallbackUserOperation(comment.getAddedBy().getId());
        }
    }

    private boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.em.find(User.class, (Object)userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.em.persist((Object)user);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

