/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.util.List;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.drools.core.util.StringUtils;
import org.jbpm.task.Attachment;
import org.jbpm.task.Content;
import org.jbpm.task.User;
import org.jbpm.task.api.TaskAttachmentService;
import org.jbpm.task.identity.UserGroupCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Decorator
public class UserGroupTaskAttachmentDecorator
implements TaskAttachmentService {
    @Inject
    @Delegate
    private TaskAttachmentService attachmentService;
    @Inject
    private UserGroupCallback userGroupCallback;
    @Inject
    private EntityManager em;

    @Override
    public long addAttachment(long taskId, Attachment attachment, Content content) {
        this.doCallbackOperationForAttachment(attachment);
        long attachmentId = this.attachmentService.addAttachment(taskId, attachment, content);
        return attachmentId;
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId) {
        this.attachmentService.deleteAttachment(taskId, attachmentId);
    }

    @Override
    public List<Attachment> getAllAttachmentsByTaskId(long taskId) {
        return this.attachmentService.getAllAttachmentsByTaskId(taskId);
    }

    @Override
    public Attachment getAttachmentById(long attachId) {
        return this.attachmentService.getAttachmentById(attachId);
    }

    private void doCallbackOperationForAttachment(Attachment attachment) {
        if (attachment != null && attachment.getAttachedBy() != null) {
            this.doCallbackUserOperation(attachment.getAttachedBy().getId());
        }
    }

    private boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    private void addUserFromCallbackOperation(String userId) {
        try {
            boolean userExists;
            boolean bl = userExists = this.em.find(User.class, (Object)userId) != null;
            if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
                User user = new User(userId);
                this.em.persist((Object)user);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

