/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.command.Context;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Content;
import org.jbpm.task.ContentData;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskCompletedEvent;
import org.jbpm.task.events.BeforeTaskCompletedEvent;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.utils.ContentMarshallerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class CompleteTaskCommand<Void>
extends TaskCommand {
    private Map<String, Object> data;

    public CompleteTaskCommand(long taskId, String userId, Map<String, Object> data) {
        this.taskId = taskId;
        this.userId = userId;
        this.data = data;
    }

    public Void execute(Context cntxt) {
        boolean operationAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskCompletedEvent>(){}}).fire((Object)task);
        boolean bl = operationAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!operationAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            task.getTaskData().setStatus(Status.Completed);
        }
        if (this.data != null) {
            ContentData result = ContentMarshallerHelper.marshal(this.data, null);
            Content content = new Content();
            content.setContent(result.getContent());
            context.getEm().persist((Object)content);
            task.getTaskData().setOutput(content.getId(), result);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskCompletedEvent>(){}}).fire((Object)task);
        return null;
    }
}

