/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import org.jbpm.task.I18NText;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@SequenceGenerator(name="notificationIdSeq", sequenceName="NOTIFICATION_ID_SEQ", allocationSize=1)
public class Notification
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="notificationIdSeq")
    private long id;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Notification_Documentation_Id", nullable=true)
    private List<I18NText> documentation = Collections.emptyList();
    private int priority;
    @ManyToMany
    @JoinTable(name="Notification_Recipients", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> recipients = Collections.emptyList();
    @ManyToMany
    @JoinTable(name="Notification_BAs", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="entity_id")})
    private List<OrganizationalEntity> businessAdministrators = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Notification_Names_Id", nullable=true)
    private List<I18NText> names = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Notification_Subjects_Id", nullable=true)
    private List<I18NText> subjects = Collections.emptyList();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Notification_Descriptions_Id", nullable=true)
    private List<I18NText> descriptions = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeInt(this.priority);
        CollectionUtils.writeOrganizationalEntityList(this.recipients, out);
        CollectionUtils.writeOrganizationalEntityList(this.businessAdministrators, out);
        CollectionUtils.writeI18NTextList(this.documentation, out);
        CollectionUtils.writeI18NTextList(this.names, out);
        CollectionUtils.writeI18NTextList(this.subjects, out);
        CollectionUtils.writeI18NTextList(this.descriptions, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.priority = in.readInt();
        this.recipients = CollectionUtils.readOrganizationalEntityList(in);
        this.businessAdministrators = CollectionUtils.readOrganizationalEntityList(in);
        this.documentation = CollectionUtils.readI18NTextList(in);
        this.names = CollectionUtils.readI18NTextList(in);
        this.subjects = CollectionUtils.readI18NTextList(in);
        this.descriptions = CollectionUtils.readI18NTextList(in);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public NotificationType getNotificationType() {
        return NotificationType.Default;
    }

    public List<I18NText> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(List<I18NText> documentation) {
        this.documentation = documentation;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<OrganizationalEntity> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<OrganizationalEntity> recipients) {
        this.recipients = recipients;
    }

    public List<OrganizationalEntity> getBusinessAdministrators() {
        return this.businessAdministrators;
    }

    public void setBusinessAdministrators(List<OrganizationalEntity> businessAdministrators) {
        this.businessAdministrators = businessAdministrators;
    }

    public List<I18NText> getNames() {
        return this.names;
    }

    public void setNames(List<I18NText> names) {
        this.names = names;
    }

    public List<I18NText> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<I18NText> subjects) {
        this.subjects = subjects;
    }

    public List<I18NText> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<I18NText> descriptions) {
        this.descriptions = descriptions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.priority;
        result = 31 * result + CollectionUtils.hashCode(this.documentation);
        result = 31 * result + CollectionUtils.hashCode(this.recipients);
        result = 31 * result + CollectionUtils.hashCode(this.businessAdministrators);
        result = 31 * result + CollectionUtils.hashCode(this.names);
        result = 31 * result + CollectionUtils.hashCode(this.subjects);
        result = 31 * result + CollectionUtils.hashCode(this.descriptions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return CollectionUtils.equals(this.businessAdministrators, other.businessAdministrators) && CollectionUtils.equals(this.documentation, other.documentation) && CollectionUtils.equals(this.recipients, other.recipients) && CollectionUtils.equals(this.descriptions, other.descriptions) && CollectionUtils.equals(this.names, other.names) && CollectionUtils.equals(this.subjects, other.subjects);
    }
}

