/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.identity;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.task.Group;
import org.jbpm.task.User;
import org.jbpm.task.identity.UserGroupCallback;
import org.jbpm.task.utils.MVELUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvelUserGroupCallbackImpl
implements UserGroupCallback {
    private Map<User, List<Group>> userGroupMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MvelUserGroupCallbackImpl() {
        Reader reader = null;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        try {
            reader = new InputStreamReader(this.getClass().getResourceAsStream("UserGroupsAssignmentsOne.mvel"));
            this.userGroupMapping = (Map)MVELUtils.eval(reader, vars);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            reader = null;
        }
    }

    @Override
    public boolean existsUser(String userId) {
        for (User u : this.userGroupMapping.keySet()) {
            if (!u.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existsGroup(String groupId) {
        for (User u : this.userGroupMapping.keySet()) {
            List<Group> groups = this.userGroupMapping.get(u);
            for (Group g : groups) {
                if (!g.getId().equals(groupId)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds) {
        return this.getGroupsForUser(userId);
    }

    @Override
    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        return this.getGroupsForUser(userId);
    }

    public List<String> getGroupsForUser(String userId) {
        for (User u : this.userGroupMapping.keySet()) {
            if (!u.getId().equals(userId)) continue;
            ArrayList<String> groupList = new ArrayList<String>();
            List<Group> userGroupList = this.userGroupMapping.get(u);
            for (Group g : userGroupList) {
                groupList.add(g.getId());
            }
            return groupList;
        }
        return null;
    }
}

