/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.command.Context;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.task.Group;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.commands.CommandsUtil;
import org.jbpm.task.commands.TaskCommand;
import org.jbpm.task.commands.TaskContext;
import org.jbpm.task.events.AfterTaskResumedEvent;
import org.jbpm.task.events.BeforeTaskResumedEvent;
import org.jbpm.task.exception.PermissionDeniedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class ResumeTaskCommand
extends TaskCommand {
    private long taskId;
    private String userId;

    public ResumeTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskResumedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!(adminAllowed || potOwnerAllowed || ownerAllowed)) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if ((potOwnerAllowed || adminAllowed) && task.getTaskData().getPreviousStatus().equals((Object)Status.Ready)) {
            task.getTaskData().setStatus(task.getTaskData().getPreviousStatus());
        }
        if ((ownerAllowed || adminAllowed) && (task.getTaskData().getPreviousStatus().equals((Object)Status.Reserved) || task.getTaskData().getPreviousStatus().equals((Object)Status.InProgress))) {
            task.getTaskData().setStatus(task.getTaskData().getPreviousStatus());
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskResumedEvent>(){}}).fire((Object)task);
        return null;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }
}

