/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.SessionWriter;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.hornetq.HornetQSessionWriter;
import org.kie.SystemEventListener;

public class HornetQTaskClientHandler
extends BaseClientHandler {
    private TaskClientHandler handler;
    private Map<String, ClientProducer> producers;

    public HornetQTaskClientHandler(SystemEventListener systemEventListener) {
        this.handler = new TaskClientHandler(this.responseHandlers, systemEventListener);
        this.producers = new HashMap<String, ClientProducer>();
    }

    public TaskClient getClient() {
        return this.handler.getClient();
    }

    public void setClient(TaskClient client) {
        this.handler.setClient(client);
    }

    public void exceptionCaught(ClientSession session, Throwable cause) throws Exception {
    }

    public void messageReceived(ClientSession session, Object message, String producerId) throws Exception {
        ClientProducer producer = this.producers.get(producerId);
        if (producer == null) {
            producer = session.createProducer(producerId);
        }
        this.handler.messageReceived((SessionWriter)new HornetQSessionWriter(session, producer), message);
    }
}

