/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.impl.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.kie.internal.task.api.model.TaskEvent;

@Entity
@Table(name="TaskEvent")
@SequenceGenerator(name="taskEventIdSeq", sequenceName="TASK_EVENT_ID_SEQ")
public class TaskEventImpl
implements TaskEvent,
Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="taskEventIdSeq")
    @Column(name="id")
    private Long id;
    @Version
    @Column(name="OPTLOCK")
    private Integer version;
    private Long taskId;
    private Long workItemId;
    @Enumerated(value=EnumType.STRING)
    private TaskEvent.TaskEventType type;
    private Long processInstanceId;
    private String userId;
    private String message;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date logTime;

    public TaskEventImpl() {
    }

    public TaskEventImpl(long taskId, TaskEvent.TaskEventType type, String userId) {
        this.taskId = taskId;
        this.type = type;
        this.userId = userId;
        this.logTime = new Date();
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, String userId, Date logTime) {
        this.taskId = taskId;
        this.type = type;
        this.userId = userId;
        this.logTime = logTime;
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId, Date logTime) {
        this.taskId = taskId;
        this.type = type;
        this.processInstanceId = processInstanceId;
        this.workItemId = workItemId;
        this.userId = userId;
        this.logTime = logTime;
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId) {
        this(taskId, type, processInstanceId, workItemId, userId, new Date());
    }

    public TaskEventImpl(Long taskId, TaskEvent.TaskEventType type, Long processInstanceId, Long workItemId, String userId, String message) {
        this(taskId, type, processInstanceId, workItemId, userId, new Date());
        this.message = message;
    }

    public long getId() {
        return this.id;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public TaskEvent.TaskEventType getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.processInstanceId = in.readLong();
        this.taskId = in.readLong();
        this.type = TaskEvent.TaskEventType.valueOf((String)in.readUTF());
        this.message = in.readUTF();
        this.userId = in.readUTF();
        this.workItemId = in.readLong();
        if (in.readBoolean()) {
            this.logTime = new Date(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeLong(this.processInstanceId);
        out.writeLong(this.taskId);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        } else {
            out.writeUTF("");
        }
        if (this.message != null) {
            out.writeUTF(this.message);
        } else {
            out.writeUTF("");
        }
        if (this.userId != null) {
            out.writeUTF(this.userId);
        } else {
            out.writeUTF("");
        }
        out.writeLong(this.workItemId);
        if (this.logTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.logTime.getTime());
        } else {
            out.writeBoolean(false);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 97 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 97 * hash + (this.taskId != null ? this.taskId.hashCode() : 0);
        hash = 97 * hash + (this.workItemId != null ? this.workItemId.hashCode() : 0);
        hash = 97 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 97 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 97 * hash + (this.processInstanceId != null ? this.processInstanceId.hashCode() : 0);
        hash = 97 * hash + (this.userId != null ? this.userId.hashCode() : 0);
        hash = 97 * hash + (this.logTime != null ? this.logTime.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEventImpl other = (TaskEventImpl)obj;
        if (!(this.id == other.id || this.id != null && this.id.equals(other.id))) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        if (!(this.taskId == other.taskId || this.taskId != null && this.taskId.equals(other.taskId))) {
            return false;
        }
        if (!(this.workItemId == other.workItemId || this.workItemId != null && this.workItemId.equals(other.workItemId))) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!this.message.equals(other.message)) {
            return false;
        }
        if (!(this.processInstanceId == other.processInstanceId || this.processInstanceId != null && this.processInstanceId.equals(other.processInstanceId))) {
            return false;
        }
        if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
            return false;
        }
        return this.logTime == other.logTime || this.logTime != null && this.logTime.equals(other.logTime);
    }
}

