/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.event.RowSelectionHandler;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.model.HistoryActivityInstanceRef;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryInstanceListView
implements WidgetProvider,
ViewInterface,
DataDriven {
    public static final String ID = HistoryInstanceListView.class.getName();
    private Controller controller;
    private MosaicPanel instanceList = null;
    private ListBox<HistoryProcessInstanceRef> listBoxHistory;
    private ListBox<HistoryActivityInstanceRef> listBoxInstanceActivity;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<HistoryProcessInstanceRef> cachedInstances = null;
    private List<HistoryActivityInstanceRef> cachedInstancesActivity = null;
    private List<String> executedActivities = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private PagingPanel pagingPanel;
    MosaicPanel panel;
    private Button diagramBtn;
    private WidgetWindowPanel diagramWindowPanel;
    private ActivityDiagramView diagramView;

    public void provideWidget(ProvisioningCallback callback) {
        this.appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
        this.panel = new MosaicPanel();
        this.panel.setPadding(0);
        ((Controller)Registry.get(Controller.class)).addView(ID, (ViewInterface)this);
        this.initialize();
        callback.onSuccess((Widget)this.panel);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.instanceList.setPadding(0);
            this.instanceList.setWidgetSpacing(0);
            this.listBoxHistory = this.createHistoryListBox();
            this.listBoxInstanceActivity = this.createHistoryActivitiesListBox();
            MosaicPanel toolBox = new MosaicPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            toolBox.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new Button("Refresh", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            this.diagramBtn = new Button("Diagram", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            toolBar.add((Widget)this.diagramBtn);
            this.diagramBtn.setEnabled(false);
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBoxHistory, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.pagingPanel = new PagingPanel((PagingCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.instanceList.add((Widget)this.pagingPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBoxInstanceActivity, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            MosaicPanel layout = new MosaicPanel((LayoutManager)new BorderLayout());
            layout.setPadding(0);
            layout.add((Widget)this.instanceList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            this.panel.add((Widget)layout);
            this.isInitialized = true;
            this.executedActivities = new ArrayList();
        }
    }

    public HistoryProcessInstanceRef getSelection() {
        HistoryProcessInstanceRef selection = null;
        if (this.listBoxHistory.getSelectedIndex() != -1) {
            selection = (HistoryProcessInstanceRef)this.listBoxHistory.getItem(this.listBoxHistory.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.diagramView = new ActivityDiagramView();
        controller.addView(ActivityDiagramView.ID, (ViewInterface)this.diagramView);
    }

    public void reset() {
        this.currentDefinition = null;
        this.cachedInstances = new ArrayList();
        this.renderUpdate();
        this.diagramBtn.setEnabled(false);
    }

    public void update(Object ... data) {
        if (data[0] instanceof ProcessDefinitionRef) {
            this.currentDefinition = (ProcessDefinitionRef)data[0];
            this.cachedInstances = (List)data[1];
            this.renderUpdate();
            DefaultListModel model = (DefaultListModel)this.listBoxInstanceActivity.getModel();
            model.clear();
            this.diagramBtn.setEnabled(false);
        } else {
            this.cachedInstancesActivity = (List)data[0];
            this.renderHistoryActivityList();
        }
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, (boolean)isLoading);
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
        }
    }

    private void bindData(List<HistoryProcessInstanceRef> instances) {
        DefaultListModel model = (DefaultListModel)this.listBoxHistory.getModel();
        model.clear();
        List list = this.pagingPanel.trim(instances);
        for (HistoryProcessInstanceRef inst : list) {
            model.add((Object)inst);
        }
        this.panel.invalidate();
    }

    private void renderHistoryActivityList() {
        if (this.cachedInstancesActivity != null) {
            DefaultListModel model = (DefaultListModel)this.listBoxInstanceActivity.getModel();
            model.clear();
            this.executedActivities.clear();
            for (HistoryActivityInstanceRef def : this.cachedInstancesActivity) {
                model.add((Object)def);
                this.executedActivities.add(def.getActivityName());
            }
            if (this.listBoxInstanceActivity.getSelectedIndex() != -1) {
                this.listBoxInstanceActivity.setItemSelected(this.listBoxInstanceActivity.getSelectedIndex(), false);
            }
        }
    }

    protected ListBox<HistoryProcessInstanceRef> createHistoryListBox() {
        this.listBoxHistory = new ListBox(new String[]{"<b>Instance</b>", "State", "Start Date", "End Date", "Duration"});
        this.listBoxHistory.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.listBoxHistory.addRowSelectionHandler((RowSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.listBoxHistory;
    }

    private ListBox<HistoryActivityInstanceRef> createHistoryActivitiesListBox() {
        ListBox listBox = new ListBox(new String[]{"ActivityName", "StartTime", "EndTime", "Duration"});
        listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        return listBox;
    }

    private void createDiagramWindow() {
        MosaicPanel layout = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        layout.setStyleName("bpm-window-layout");
        layout.setPadding(5);
        Label header = new Label("Instance: ");
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        layout.add((Widget)this.diagramView, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        this.diagramWindowPanel = new WidgetWindowPanel("Process Instance Activity", (Widget)layout, true);
    }

    static /* synthetic */ Controller access$000(HistoryInstanceListView x0) {
        return x0.controller;
    }

    static /* synthetic */ ProcessDefinitionRef access$100(HistoryInstanceListView x0) {
        return x0.currentDefinition;
    }

    static /* synthetic */ List access$200(HistoryInstanceListView x0) {
        return x0.executedActivities;
    }

    static /* synthetic */ void access$300(HistoryInstanceListView x0) {
        x0.createDiagramWindow();
    }

    static /* synthetic */ void access$400(HistoryInstanceListView x0) {
        x0.renderUpdate();
    }

    static /* synthetic */ SimpleDateFormat access$500(HistoryInstanceListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ListBox access$600(HistoryInstanceListView x0) {
        return x0.listBoxHistory;
    }

    static /* synthetic */ Button access$700(HistoryInstanceListView x0) {
        return x0.diagramBtn;
    }
}

