/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.util;

import java.util.Date;
import org.jboss.bpm.console.client.util.DateLocale;
import org.jboss.bpm.console.client.util.SimpleDateParser;

public class SimpleDateFormat {
    private String format;
    private DateLocale locale = new DateLocale();
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public DateLocale getLocale() {
        return this.locale;
    }

    public void setLocale(DateLocale locale) {
        this.locale = locale;
    }

    public SimpleDateFormat() {
        this.format = DEFAULT_FORMAT;
    }

    public SimpleDateFormat(String pattern) {
        this.format = pattern;
    }

    public String format(Date date) {
        String f = "";
        if (this.format != null && this.format.length() > 0) {
            String lastTokenType = null;
            String currentToken = "";
            for (int i = 0; i < this.format.length(); ++i) {
                String currentTokenType;
                String thisChar = this.format.substring(i, i + 1);
                String string = currentTokenType = DateLocale.SUPPORTED_DF_TOKENS.contains(thisChar) ? thisChar : "";
                if (currentTokenType.equals(lastTokenType) || i == 0) {
                    currentToken = currentToken + thisChar;
                    lastTokenType = currentTokenType;
                    continue;
                }
                f = "".equals(lastTokenType) ? f + currentToken : f + this.handleToken(currentToken, date);
                currentToken = thisChar;
                lastTokenType = currentTokenType;
            }
            f = "".equals(lastTokenType) ? f + currentToken : f + this.handleToken(currentToken, date);
        }
        return f;
    }

    private String handleToken(String token, Date date) {
        String response = token;
        String tc = token.substring(0, 1);
        if ("E".equals(tc)) {
            response = token.length() > 3 ? this.locale.getWEEKDAY_LONG()[date.getDay()] : this.locale.getWEEKDAY_SHORT()[date.getDay()];
        } else if ("d".equals(tc)) {
            response = token.length() == 1 ? Integer.toString(date.getDate()) : this.twoCharDateField(date.getDate());
        } else if ("M".equals(tc)) {
            switch (token.length()) {
                case 1: {
                    response = Integer.toString(date.getMonth() + 1);
                    break;
                }
                case 2: {
                    response = this.twoCharDateField(date.getMonth() + 1);
                    break;
                }
                case 3: {
                    response = this.locale.MONTH_SHORT[date.getMonth()];
                    break;
                }
                default: {
                    response = this.locale.MONTH_LONG[date.getMonth()];
                    break;
                }
            }
        } else if ("y".equals(tc)) {
            response = token.length() > 2 ? Integer.toString(date.getYear() + 1900) : this.twoCharDateField(date.getYear());
        } else if ("h".equals(tc)) {
            int h = date.getHours();
            if (h == 0) {
                h = 12;
            } else if (h > 12) {
                h -= 12;
            }
            response = token.length() > 1 ? this.twoCharDateField(h) : Integer.toString(h);
        } else if ("H".equals(tc)) {
            response = token.length() > 1 ? this.twoCharDateField(date.getHours()) : Integer.toString(date.getHours());
        } else if ("m".equals(tc)) {
            response = token.length() > 1 ? this.twoCharDateField(date.getMinutes()) : Integer.toString(date.getMinutes());
        } else if ("s".equals(tc)) {
            response = token.length() > 1 ? this.twoCharDateField(date.getSeconds()) : Integer.toString(date.getSeconds());
        } else if ("a".equals(tc)) {
            int hour = date.getHours();
            response = hour > 11 ? DateLocale.getPM() : DateLocale.getAM();
        }
        return response;
    }

    private String twoCharDateField(int num) {
        String res = Integer.toString(num + 1900);
        res = res.substring(res.length() - 2);
        return res;
    }

    private static Date newDate(long time) {
        return new Date(time);
    }

    public Date parse(String source) {
        return SimpleDateParser.parse((String)source, (String)this.format);
    }
}

