/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import java.util.StringTokenizer;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ScrollLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.process.GetProcessInstanceEventsAction;
import org.jboss.bpm.console.client.process.InstanceDataView;
import org.jboss.bpm.console.client.process.LoadActivityDiagramAction;
import org.jboss.bpm.console.client.process.LoadInstanceActivityImage;
import org.jboss.bpm.console.client.process.UpdateInstanceDataAction;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDetailView
extends CaptionLayoutPanel
implements ViewInterface {
    public static final String ID = InstanceDetailView.class.getName();
    private Controller controller;
    private PropertyGrid grid;
    private ProcessInstanceRef currentInstance;
    private Button diagramBtn;
    private Button instanceDataBtn;
    private WidgetWindowPanel diagramWindowPanel;
    private WidgetWindowPanel instanceDataWindowPanel;
    private ApplicationContext appContext;
    private ActivityDiagramView diagramView;
    private InstanceDataView instanceDataView;
    private boolean hasDiagramPlugin;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ProcessDefinitionRef currentDefintion;
    private boolean isRiftsawInstance;
    private boolean isjBPMInstance;
    private ListBox<String> processEvents;

    public InstanceDetailView() {
        super("Execution details");
        this.appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
        this.isRiftsawInstance = this.appContext.getConfig().getProfileName().equals("BPEL Console");
        this.isjBPMInstance = this.appContext.getConfig().getProfileName().equals("jBPM Console");
        if (this.isRiftsawInstance) {
            this.controller = (Controller)Registry.get(Controller.class);
            this.controller.addView(ID, (ViewInterface)this);
            this.controller.addAction(GetProcessInstanceEventsAction.ID, (ActionInterface)new GetProcessInstanceEventsAction());
        }
        super.setStyleName("bpm-detail-panel");
        super.setLayout((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        this.grid = new PropertyGrid(new String[]{"Process:", "Instance ID:", "State", "Start Date:", "Activity:"});
        this.add((Widget)this.grid, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        MosaicPanel buttonPanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        if (this.isRiftsawInstance) {
            this.diagramBtn = new Button("Execution Path", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.isjBPMInstance) {
            this.diagramBtn = new Button("Diagram", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.diagramBtn.setVisible(!this.isRiftsawInstance);
        }
        this.diagramBtn.setEnabled(false);
        buttonPanel.add((Widget)this.diagramBtn, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.instanceDataBtn = new Button("Instance Data", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceDataBtn.setEnabled(false);
        buttonPanel.add((Widget)this.instanceDataBtn, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.add((Widget)buttonPanel);
        this.hasDiagramPlugin = ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.GraphViewerPlugin");
    }

    private void createDiagramWindow(ProcessInstanceRef inst) {
        if (this.isRiftsawInstance) {
            ScrollLayoutPanel layout = new ScrollLayoutPanel();
            layout.setStyleName("bpm-window-layout");
            layout.setPadding(5);
            Label header = new Label("Instance: " + inst.getId());
            header.setStyleName("bpm-label-header");
            layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            DecoratedTabLayoutPanel tabPanel = new DecoratedTabLayoutPanel(false);
            tabPanel.setPadding(5);
            MosaicPanel diaViewLayout = new MosaicPanel();
            diaViewLayout.add((Widget)this.diagramView, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            tabPanel.add((Widget)this.diagramView, "View");
            this.processEvents = new ListBox(new String[]{"Process Events"});
            this.processEvents.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            MosaicPanel sourcePanel = new MosaicPanel();
            sourcePanel.add((Widget)this.processEvents, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.VERTICAL));
            tabPanel.add((Widget)sourcePanel, "Source");
            tabPanel.selectTab(0);
            layout.add((Widget)tabPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.diagramWindowPanel = new WidgetWindowPanel("Process Instance Activity", (Widget)layout, true);
            this.controller.handleEvent(new Event(GetProcessInstanceEventsAction.ID, (Object)inst.getId()));
        } else if (this.isjBPMInstance) {
            MosaicPanel layout = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            layout.setStyleName("bpm-window-layout");
            layout.setPadding(5);
            Label header = new Label("Instance: " + inst.getId());
            header.setStyleName("bpm-label-header");
            layout.add((Widget)header, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            layout.add((Widget)this.diagramView, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.diagramWindowPanel = new WidgetWindowPanel("Process Instance Activity", (Widget)layout, true);
        }
    }

    public void populateProcessInstanceEvents(List<StringRef> refs) {
        DefaultListModel model = (DefaultListModel)this.processEvents.getModel();
        model.clear();
        for (StringRef value : refs) {
            model.add((Object)this.formatResult(value.getValue()));
        }
    }

    private String formatResult(String value) {
        StringBuffer sbuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(value, "~");
        sbuffer.append(st.nextToken() + " : ");
        while (st.hasMoreTokens()) {
            sbuffer.append("<br/>");
            sbuffer.append(st.nextToken());
        }
        return sbuffer.toString();
    }

    private void createDataWindow(ProcessInstanceRef inst) {
        this.instanceDataView.clear();
        this.instanceDataWindowPanel = new WidgetWindowPanel("Process Instance Data: " + inst.getId(), (Widget)this.instanceDataView, true);
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.diagramView = new ActivityDiagramView();
        this.instanceDataView = new InstanceDataView();
        controller.addView(ActivityDiagramView.ID, (ViewInterface)this.diagramView);
        controller.addView(InstanceDataView.ID, (ViewInterface)this.instanceDataView);
        controller.addAction(LoadActivityDiagramAction.ID, (ActionInterface)new LoadActivityDiagramAction());
        if (this.isRiftsawInstance) {
            controller.addAction(LoadInstanceActivityImage.class.getName(), (ActionInterface)new LoadInstanceActivityImage());
        }
        controller.addAction(UpdateInstanceDataAction.ID, (ActionInterface)new UpdateInstanceDataAction());
    }

    public void update(ProcessDefinitionRef def, ProcessInstanceRef instance) {
        this.currentDefintion = def;
        this.currentInstance = instance;
        String currentNodeName = instance.getRootToken() != null ? instance.getRootToken().getCurrentNodeName() : "n/a";
        String[] values = new String[]{def.getName(), instance.getId(), String.valueOf(instance.getState()), this.dateFormat.format(instance.getStartDate()), currentNodeName};
        this.grid.update(values);
        if (this.hasDiagramPlugin) {
            this.diagramBtn.setEnabled(true);
        }
        this.instanceDataBtn.setEnabled(true);
    }

    public void clearView() {
        this.grid.clear();
        this.currentDefintion = null;
        this.currentInstance = null;
        this.diagramBtn.setEnabled(false);
        this.instanceDataBtn.setEnabled(false);
    }

    private ProcessDefinitionRef getCurrentDefintion() {
        return this.currentDefintion;
    }

    private ProcessInstanceRef getCurrentInstance() {
        return this.currentInstance;
    }

    static /* synthetic */ ProcessDefinitionRef access$000(InstanceDetailView x0) {
        return x0.getCurrentDefintion();
    }

    static /* synthetic */ ProcessInstanceRef access$100(InstanceDetailView x0) {
        return x0.getCurrentInstance();
    }

    static /* synthetic */ void access$200(InstanceDetailView x0, ProcessInstanceRef x1) {
        x0.createDiagramWindow(x1);
    }

    static /* synthetic */ Controller access$300(InstanceDetailView x0) {
        return x0.controller;
    }

    static /* synthetic */ ProcessInstanceRef access$400(InstanceDetailView x0) {
        return x0.currentInstance;
    }

    static /* synthetic */ void access$500(InstanceDetailView x0, ProcessInstanceRef x1) {
        x0.createDataWindow(x1);
    }
}

