/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.server.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.picketlink.authentication.event.PreAuthenticateEvent;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

@ApplicationScoped
public class PicketLinkDefaultUsers {
    @Inject
    private PartitionManager partitionManager;
    private final AtomicBoolean hasInitialized = new AtomicBoolean(false);

    public void onPreAuthenticateEvent(@Observes PreAuthenticateEvent event) {
        if (!this.hasInitialized.getAndSet(true)) {
            this.setup();
        }
    }

    private void setup() {
        IdentityManager identityManager = this.partitionManager.createIdentityManager();
        RelationshipManager relationshipManager = this.partitionManager.createRelationshipManager();
        User admin = new User("admin");
        User director = new User("director");
        User user = new User("user");
        User guest = new User("guest");
        identityManager.add((IdentityType)admin);
        identityManager.add((IdentityType)director);
        identityManager.add((IdentityType)user);
        identityManager.add((IdentityType)guest);
        identityManager.updateCredential((Account)admin, (Object)new Password("admin"));
        identityManager.updateCredential((Account)director, (Object)new Password("director"));
        identityManager.updateCredential((Account)user, (Object)new Password("user"));
        identityManager.updateCredential((Account)guest, (Object)new Password("guest"));
        Role roleAdmin = new Role("admin");
        Role roleAnalyst = new Role("analyst");
        identityManager.add((IdentityType)roleAdmin);
        identityManager.add((IdentityType)roleAnalyst);
        relationshipManager.add((Relationship)new Grant((IdentityType)admin, roleAnalyst));
        relationshipManager.add((Relationship)new Grant((IdentityType)admin, roleAdmin));
        relationshipManager.add((Relationship)new Grant((IdentityType)director, roleAnalyst));
        relationshipManager.add((Relationship)new Grant((IdentityType)user, roleAnalyst));
    }
}

