/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.fieldTypes.document.handling;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.fieldHandlers.plugable.PlugableFieldHandler;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.controller.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.fieldTypes.document.handling.JBPMDocumentFieldTypeHandler")
public class JBPMDocumentFieldTypeHandler
extends PlugableFieldHandler {
    private Logger log = LoggerFactory.getLogger(JBPMDocumentFieldTypeHandler.class);
    public final String[] SIZE_UNITS = new String[]{"bytes", "Kb", "Mb"};
    protected String dropIcon;
    protected String iconFolder;
    protected String defaultFileIcon;
    protected Map<String, String> icons;

    @PostConstruct
    public void init() {
        this.dropIcon = "/formModeler/images/general/16x16/ico-trash.png";
        this.iconFolder = "/formModeler/images/fileTypeIcons/16x16/";
        this.defaultFileIcon = "RTF.png";
        this.icons = new HashMap<String, String>();
        this.icons.put("ace", "ACE.png");
        this.icons.put("css", "CSS.png");
        this.icons.put("csv", "CSV.png");
        this.icons.put("swf", "Flash.png");
        this.icons.put("fla", "Flash.png");
        this.icons.put("htm", "HTML.png");
        this.icons.put("html", "HTML.png");
        this.icons.put("jar", "JAR.png");
        this.icons.put("java", "Java.png");
        this.icons.put("jsp", "JSP.png");
        this.icons.put("mp3", "MP3.png");
        this.icons.put("doc", "MSWord.png");
        this.icons.put("pdf", "PDF.png");
        this.icons.put("rar", "RAR.png");
        this.icons.put("rtf", "RTF.png");
        this.icons.put("tar", "TAR.png");
        this.icons.put("txt", "TextPlain.png");
        this.icons.put("mov", "Video.png");
        this.icons.put("avi", "Video.png");
        this.icons.put("mpg", "Video.png");
        this.icons.put("mpeg", "Video.png");
        this.icons.put("pps", "PowerPoint.png");
        this.icons.put("ppt", "PowerPoint.png");
        this.icons.put("wma", "Video.png");
        this.icons.put("wmv", "Video.png");
        this.icons.put("mp4", "Video.png");
        this.icons.put("rm", "Video.png");
        this.icons.put("wav", "WAF.png");
        this.icons.put("xls", "MSExcel.png");
        this.icons.put("zip", "ZIP.png");
        this.icons.put("gif", "Image.png");
        this.icons.put("jpg", "Image.png");
        this.icons.put("jpeg", "Image.png");
        this.icons.put("bmp", "Image.png");
        this.icons.put("png", "Image.png");
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Document oldDoc = (Document)previousValue;
        String[] deleteParam = (String[])parametersMap.get(inputName + "_delete");
        boolean delete = oldDoc != null && deleteParam != null && deleteParam.length > 0 && deleteParam[0] != null && Boolean.valueOf(deleteParam[0]) != false;
        File file = (File)filesMap.get(inputName);
        if (file != null) {
            DocumentImpl doc = new DocumentImpl(file.getName(), file.length(), new Date(file.lastModified()));
            doc.setContent(FileUtils.readFileToByteArray((File)file));
            StringBuffer url = RequestContext.getCurrentContext().getRequest().getRequestObject().getRequestURL();
            doc.addAttribute("app.url", url.substring(0, url.indexOf("/Controller")));
            return doc;
        }
        if (delete) {
            return null;
        }
        return oldDoc;
    }

    public String getShowHTML(Object value, Field field, String inputName, String namespace) {
        return this.renderField((Document)value, field, inputName, false, false);
    }

    public String getInputHTML(Object value, Field field, String inputName, String namespace, Boolean readonly) {
        return this.renderField((Document)value, field, inputName, true, readonly != false || field.getReadonly() != false);
    }

    public String renderField(Document document, Field field, String inputName, boolean showInput, boolean readonly) {
        String str = null;
        try {
            String contextPath = ControllerStatus.lookup().getRequest().getRequestObject().getContextPath();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("inputId", inputName);
            if (document != null) {
                if (StringUtils.isEmpty((String)document.getIdentifier())) {
                    context.put("showLink", Boolean.FALSE);
                } else {
                    context.put("showLink", Boolean.TRUE);
                    context.put("downloadLink", document.getLink());
                }
                context.put("showDownload", Boolean.TRUE);
                context.put("fileName", StringEscapeUtils.escapeHtml((String)document.getName()));
                context.put("fileSize", this.getFileSize(document.getSize()));
                context.put("fileIcon", contextPath + this.getFileIcon(document));
                context.put("dropIcon", contextPath + this.dropIcon);
            } else {
                context.put("showDownload", Boolean.FALSE);
            }
            context.put("readonly", readonly);
            context.put("showInput", showInput);
            InputStream src = ((Object)((Object)this)).getClass().getResourceAsStream("input.ftl");
            Configuration cfg = new Configuration();
            BeansWrapper defaultInstance = new BeansWrapper();
            defaultInstance.setSimpleMapWrapper(true);
            cfg.setObjectWrapper((ObjectWrapper)defaultInstance);
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(inputName, (Reader)new InputStreamReader(src), cfg);
            StringWriter out = new StringWriter();
            temp.process(context, (Writer)out);
            out.flush();
            str = out.getBuffer().toString();
        }
        catch (Exception e) {
            this.log.warn("Failed to process template for field '{}': {}", (Object)field.getFieldName(), (Object)e);
        }
        return str;
    }

    protected String getFileSize(long longSize) {
        int position;
        double size = longSize;
        for (position = 0; position < this.SIZE_UNITS.length && size > 1024.0; size /= 1024.0, ++position) {
        }
        DecimalFormat df = new DecimalFormat("#,###.##");
        return df.format(size) + " " + this.SIZE_UNITS[position];
    }

    protected String getFileIcon(Document document) {
        if (document != null) {
            String extension;
            int index = document.getName().lastIndexOf(".");
            if (index != -1 && this.icons.get(extension = document.getName().substring(index + 1).toLowerCase()) != null) {
                return this.iconFolder + this.icons.get(extension);
            }
            return this.iconFolder + this.defaultFileIcon;
        }
        return null;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{Document.class.getName()};
    }

    public boolean isEmpty(Object value) {
        return value == null;
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        return Collections.EMPTY_MAP;
    }
}

