/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.process.core.datatype.DataType;
import org.drools.runtime.rule.impl.InternalAgenda;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.EventListener;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.rule.FactHandle;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public class RuleSetNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private String ruleFlowGroup;

    protected RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A RuleSetNode only accepts default incoming connections!");
        }
        this.setRuleFlowGroup(this.resolveRuleFlowGroup(this.getRuleSetNode().getRuleFlowGroup()));
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        Map<String, Object> inputs = this.evaluateParameters(this.getRuleSetNode());
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            String inputKey = this.getRuleFlowGroup() + "_" + this.getProcessInstance().getId() + "_" + entry.getKey();
            this.factHandles.put(inputKey, kruntime.insert(entry.getValue()));
        }
        this.addRuleSetListener();
        ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).activateRuleFlowGroup(this.getRuleFlowGroup(), this.getProcessInstance().getId(), this.getUniqueId());
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addRuleSetListener();
    }

    private String getRuleSetEventType() {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime instanceof StatefulKnowledgeSession) {
            return "RuleFlowGroup_" + this.getRuleFlowGroup() + "_" + ((StatefulKnowledgeSession)kruntime).getId();
        }
        return "RuleFlowGroup_" + this.getRuleFlowGroup();
    }

    private void addRuleSetListener() {
        this.getProcessInstance().addEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void cancel() {
        super.cancel();
        ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).deactivateRuleFlowGroup(this.getRuleFlowGroup());
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (this.getRuleSetEventType().equals(type)) {
            this.removeEventListeners();
            this.retractFacts();
            this.triggerCompleted();
        }
    }

    public void retractFacts() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        for (Map.Entry<String, FactHandle> entry : this.factHandles.entrySet()) {
            Object object = ((StatefulKnowledgeSession)kruntime).getObject(entry.getValue());
            String key = entry.getKey();
            key = key.replaceAll(this.getRuleFlowGroup() + "_", "");
            key = key.replaceAll(this.getProcessInstance().getId() + "_", "");
            objects.put(key, object);
            kruntime.retract(entry.getValue());
        }
        RuleSetNode ruleSetNode = this.getRuleSetNode();
        if (ruleSetNode != null) {
            for (DataAssociation association : ruleSetNode.getOutAssociations()) {
                if (association.getAssignments() != null && !association.getAssignments().isEmpty()) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null) {
                    Variable varDef;
                    DataType dataType;
                    Object value = objects.get(association.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVEL.eval((String)association.getSources().get(0), (VariableResolverFactory)new MapVariableResolverFactory(objects));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && value instanceof String) {
                        value = dataType.readValue((String)value);
                    }
                    variableScopeInstance.setVariable(association.getTarget(), value);
                    continue;
                }
                System.out.println("Could not find variable scope for variable " + association.getTarget());
            }
        }
        this.factHandles.clear();
    }

    protected Map<String, Object> evaluateParameters(RuleSetNode ruleSetNode) {
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : ruleSetNode.getParameters().entrySet()) {
            Object value;
            if (!(entry.getValue() instanceof String) || (value = this.resolveVariable(entry.getValue())) == null) continue;
            replacements.put(entry.getKey(), value);
        }
        return replacements;
    }

    private Object resolveVariable(Object s) {
        if (s instanceof String) {
            Matcher matcher = PARAMETER_MATCHER.matcher((String)s);
            while (matcher.find()) {
                Object variableValue;
                String paramName = matcher.group(1);
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    if (variableValue == null) continue;
                    return variableValue;
                }
                try {
                    variableValue = MVEL.eval((String)paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    if (variableValue == null) continue;
                    return variableValue;
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + paramName);
                }
            }
        }
        return s;
    }

    private String resolveRuleFlowGroup(String origin) {
        return (String)this.resolveVariable(origin);
    }

    public Map<String, FactHandle> getFactHandles() {
        return this.factHandles;
    }

    public void setFactHandles(Map<String, FactHandle> factHandles) {
        this.factHandles = factHandles;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }
}

