/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.WorkItemHandlerNotFoundException;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Node;
import org.drools.process.core.Work;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkItemResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class WorkItemNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{(\\S+)\\}", 32);
    private long workItemId = -1L;
    private transient org.drools.runtime.process.WorkItem workItem;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public org.drools.runtime.process.WorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId >= 0L) {
            this.workItem = ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public void internalSetWorkItem(org.drools.runtime.process.WorkItem workItem) {
        this.workItem = workItem;
    }

    public boolean isInversionOfControl() {
        return false;
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getKnowledgeRuntime().update(this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)this), (Object)this);
        } else {
            try {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem((WorkItem)this.workItem);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        }
        this.workItemId = this.workItem.getId();
    }

    protected org.drools.runtime.process.WorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = new WorkItemImpl();
        ((WorkItem)this.workItem).setName(work.getName());
        ((WorkItem)this.workItem).setProcessInstanceId(this.getProcessInstance().getId());
        ((WorkItem)this.workItem).setParameters(new HashMap(work.getParameters()));
        for (Map.Entry<String, String> mapping : workItemNode.getInMappings().entrySet()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(mapping.getValue());
            } else {
                try {
                    parameterValue = MVEL.eval((String)mapping.getValue(), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + mapping.getValue());
                    System.err.println("when trying to execute Work Item " + work.getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            if (parameterValue == null) continue;
            ((WorkItem)this.workItem).setParameter(mapping.getKey(), parameterValue);
        }
        for (Map.Entry entry : this.workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVEL.eval((String)paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + paramName);
                    System.err.println("when trying to replace variable in string for Work Item " + work.getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            ((WorkItem)this.workItem).setParameter((String)entry.getKey(), (Object)s);
        }
        return this.workItem;
    }

    public void triggerCompleted(org.drools.runtime.process.WorkItem workItem) {
        this.workItem = workItem;
        WorkItemNode workItemNode = this.getWorkItemNode();
        if (workItemNode != null) {
            for (Map.Entry<String, String> mapping : this.getWorkItemNode().getOutMappings().entrySet()) {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
                if (variableScopeInstance != null) {
                    Object value = workItem.getResult(mapping.getKey());
                    if (value == null) {
                        try {
                            value = MVEL.eval((String)mapping.getKey(), (VariableResolverFactory)new WorkItemResolverFactory(workItem));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    variableScopeInstance.setVariable(mapping.getValue(), value);
                    continue;
                }
                System.err.println("Could not find variable scope for variable " + mapping.getValue());
                System.err.println("when trying to complete Work Item " + workItem.getName());
                System.err.println("Continuing without setting variable.");
            }
        }
        if (this.isInversionOfControl()) {
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            kruntime.update(kruntime.getFactHandle((Object)this), (Object)this);
        } else {
            this.triggerCompleted();
        }
    }

    public void cancel() {
        org.drools.runtime.process.WorkItem workItem = this.getWorkItem();
        if (workItem != null && workItem.getState() != 2 && workItem.getState() != 3) {
            try {
                ((WorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAbortWorkItem(this.workItemId);
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        super.cancel();
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
    }

    private void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((org.drools.runtime.process.WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((org.drools.runtime.process.WorkItem)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    public String[] getEventTypes() {
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(org.drools.runtime.process.WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(org.drools.runtime.process.WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            String nodeName = "[Dynamic]";
            org.drools.runtime.process.WorkItem workItem = this.getWorkItem();
            if (workItem != null) {
                nodeName = nodeName + " " + workItem.getParameter("TaskName");
            }
            return nodeName;
        }
        return super.getNodeName();
    }
}

