/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.executor.commands.error.AutoAckErrorCommand;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAutoAckErrorCommand
extends AutoAckErrorCommand {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAutoAckErrorCommand.class);
    private static final String RULE = "Process instances that previously failed but now are in different nodes - meaning node where they were was already completed - or completed/aborted";

    @Override
    protected List<ExecutionErrorInfo> findErrorsToAck(EntityManager em) {
        ArrayList<ExecutionErrorInfo> errorsToAck = new ArrayList<ExecutionErrorInfo>();
        TransactionManager txm = TransactionManagerFactory.get().newTransactionManager();
        boolean txOwner = txm.begin();
        try {
            String findProcessErrorsQuery = "select error from ExecutionErrorInfo error where error.acknowledged =:acknowledged and error.processInstanceId in (select pil.id from ProcessInstanceLog pil where status in (:status))";
            List processErrorsToAck = em.createQuery(findProcessErrorsQuery, ExecutionErrorInfo.class).setParameter("acknowledged", (Object)new Short("0")).setParameter("status", Arrays.asList(2, 3)).getResultList();
            errorsToAck.addAll(processErrorsToAck);
            String findNodeErrorsQuery = "select error from ExecutionErrorInfo error where error.acknowledged =:acknowledged and CAST(error.initActivityId AS string) in (select nil.nodeInstanceId from NodeInstanceLog nil where nil.processInstanceId = error.processInstanceId and nil.nodeInstanceId = CAST(error.initActivityId AS string) and nil.type = '1')";
            List nodeErrorsToAck = em.createQuery(findNodeErrorsQuery, ExecutionErrorInfo.class).setParameter("acknowledged", (Object)new Short("0")).getResultList();
            errorsToAck.addAll(nodeErrorsToAck);
            txm.commit(txOwner);
        }
        catch (Exception e) {
            logger.error("Execution error in command ProcessAutoAckErrorCommand", (Throwable)e);
            txm.rollback(txOwner);
        }
        return errorsToAck;
    }

    @Override
    protected String getAckRule() {
        return RULE;
    }
}

