/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.Collection;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.executor.CommandCallback;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkItemHandlerCmdCallback
implements CommandCallback {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWorkItemHandlerCmdCallback.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommandDone(CommandContext ctx, ExecutionResults results) {
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        logger.debug("About to complete work item {}", (Object)workItem);
        RuntimeManager manager = this.getRuntimeManager(ctx);
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)((Long)ctx.getData("processInstanceId"))));
        try {
            engine.getKieSession().getWorkItemManager().completeWorkItem(workItem.getId(), results == null ? null : results.getData());
        }
        finally {
            manager.disposeRuntimeEngine(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommandError(CommandContext ctx, final Throwable exception) {
        final Long processInstanceId = (Long)ctx.getData("processInstanceId");
        final WorkItem workItem = (WorkItem)ctx.getData("workItem");
        RuntimeManager manager = this.getRuntimeManager(ctx);
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            engine.getKieSession().execute((Command)new GenericCommand<Void>(){
                private static final long serialVersionUID = 1L;

                public Void execute(org.kie.internal.command.Context context) {
                    String exceptionName;
                    KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
                    WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId.longValue());
                    NodeInstance nodeInstance = AsyncWorkItemHandlerCmdCallback.this.getNodeInstance(workItem, processInstance);
                    ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)((org.jbpm.workflow.instance.NodeInstance)nodeInstance).resolveContextInstance("ExceptionScope", (Object)(exceptionName = exception.getClass().getName()));
                    if (exceptionScopeInstance != null) {
                        exceptionScopeInstance.handleException(exceptionName, (Object)exception);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error("Error when handling callback from executor", (Throwable)e);
        }
        finally {
            manager.disposeRuntimeEngine(engine);
        }
    }

    protected RuntimeManager getRuntimeManager(CommandContext ctx) {
        String deploymentId = (String)ctx.getData("deploymentId");
        RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(deploymentId);
        if (runtimeManager == null) {
            throw new IllegalStateException("There is no runtime manager for deployment " + deploymentId);
        }
        return runtimeManager;
    }

    protected NodeInstance getNodeInstance(WorkItem workItem, WorkflowProcessInstance processInstance) {
        Collection nodeInstances = processInstance.getNodeInstances();
        return this.getNodeInstance(workItem, nodeInstances);
    }

    protected NodeInstance getNodeInstance(WorkItem workItem, Collection<NodeInstance> nodeInstances) {
        for (NodeInstance nodeInstance : nodeInstances) {
            NodeInstance found;
            if (nodeInstance instanceof WorkItemNodeInstance) {
                if (((WorkItemNodeInstance)nodeInstance).getWorkItemId() != workItem.getId()) continue;
                return nodeInstance;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer) || (found = this.getNodeInstance(workItem, ((NodeInstanceContainer)nodeInstance).getNodeInstances())) == null) continue;
            return found;
        }
        return null;
    }
}

