/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ClassCacheManager;
import org.kie.api.executor.CommandCallback;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.Reoccurring;
import org.kie.api.executor.STATUS;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AvailableJobsExecutor.class);
    private int retries = Integer.parseInt(System.getProperty("org.kie.executor.retry.count", "3"));
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private ExecutorQueryService queryService;
    private ClassCacheManager classCacheManager;
    private ExecutorStoreService executorStoreService;

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }

    public void setExecutorStoreService(ExecutorStoreService executorStoreService) {
        this.executorStoreService = executorStoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJob() {
        block48: {
            logger.debug("Executor Thread {} Waking Up!!!", (Object)this.toString());
            try {
                ObjectInputStream in;
                RequestInfo request = (RequestInfo)this.queryService.getRequestForProcessing();
                if (request == null) break block48;
                boolean processReoccurring = false;
                Object cmd = null;
                CommandContext ctx = null;
                List<CommandCallback> callbacks = null;
                ClassLoader cl = this.getClassLoader(request.getDeploymentId());
                try {
                    logger.debug("Processing Request Id: {}, status {} command {}", new Object[]{request.getId(), request.getStatus(), request.getCommandName()});
                    byte[] reqData = request.getRequestData();
                    if (reqData != null) {
                        in = null;
                        try {
                            in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                            ctx = (CommandContext)in.readObject();
                        }
                        catch (IOException e) {
                            logger.warn("Exception while serializing context data", (Throwable)e);
                            if (processReoccurring && cmd != null && cmd instanceof Reoccurring) {
                                Date current = new Date();
                                Date nextScheduleTime = ((Reoccurring)cmd).getScheduleTime();
                                if (nextScheduleTime != null && nextScheduleTime.after(current)) {
                                    String businessKey = (String)ctx.getData("businessKey");
                                    RequestInfo requestInfo = new RequestInfo();
                                    requestInfo.setCommandName(cmd.getClass().getName());
                                    requestInfo.setKey(businessKey);
                                    requestInfo.setStatus(STATUS.QUEUED);
                                    requestInfo.setTime(nextScheduleTime);
                                    requestInfo.setMessage("Rescheduled reoccurring job");
                                    requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
                                    requestInfo.setOwner((String)ctx.getData("owner"));
                                    if (ctx.getData("retries") != null) {
                                        requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
                                    } else {
                                        requestInfo.setRetries(this.retries);
                                    }
                                    if (ctx != null) {
                                        try {
                                            ctx.getData().remove("ClassLoader");
                                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                            ObjectOutputStream oout = new ObjectOutputStream(bout);
                                            oout.writeObject(ctx);
                                            requestInfo.setRequestData(bout.toByteArray());
                                        }
                                        catch (IOException e2) {
                                            logger.warn("Error serializing context data", (Throwable)e2);
                                            requestInfo.setRequestData(null);
                                        }
                                    }
                                    this.executorStoreService.persistRequest((org.kie.api.executor.RequestInfo)requestInfo);
                                }
                            }
                            return;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break block48;
                }
                catch (Throwable e) {
                    callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                    logger.warn("Error during command {} execution {}", (Object)request.getCommandName(), (Object)e.getMessage());
                    ErrorInfo errorInfo = new ErrorInfo(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e.fillInStackTrace()));
                    errorInfo.setRequestInfo(request);
                    request.getErrorInfo().add(errorInfo);
                    logger.debug("Error Number: {}", (Object)request.getErrorInfo().size());
                    if (request.getRetries() > 0) {
                        request.setStatus(STATUS.RETRYING);
                        request.setRetries(request.getRetries() - 1);
                        List retryDelay = (List)ctx.getData("retryDelay");
                        if (retryDelay != null) {
                            long retryAdd = 0L;
                            try {
                                retryAdd = (Long)retryDelay.get(request.getExecutions());
                            }
                            catch (IndexOutOfBoundsException ex) {
                                retryAdd = (Long)retryDelay.get(retryDelay.size() - 1);
                            }
                            request.setTime(new Date(System.currentTimeMillis() + retryAdd));
                            request.setExecutions(request.getExecutions() + 1);
                            logger.info("Retrying request ( with id {}) - delay configured, next retry at {}", (Object)request.getId(), (Object)request.getTime());
                        }
                        logger.debug("Retrying ({}) still available!", (Object)request.getRetries());
                        this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
                        break block48;
                    }
                    logger.debug("Error no retries left!");
                    request.setStatus(STATUS.ERROR);
                    request.setExecutions(request.getExecutions() + 1);
                    this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
                    if (callbacks != null) {
                        for (CommandCallback handler : callbacks) {
                            handler.onCommandError(ctx, e);
                        }
                    }
                    processReoccurring = true;
                    break block48;
                }
                for (Map.Entry<String, Object> entry : this.contextData.entrySet()) {
                    ctx.setData(entry.getKey(), entry.getValue());
                }
                ctx.setData("ClassLoader", (Object)cl);
                cmd = this.classCacheManager.findCommand(request.getCommandName(), cl);
                ExecutionResults results = cmd.execute(ctx);
                callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                for (CommandCallback handler : callbacks) {
                    handler.onCommandDone(ctx, results);
                }
                if (results != null) {
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(bout);
                        out.writeObject(results);
                        byte[] respData = bout.toByteArray();
                        request.setResponseData(respData);
                    }
                    catch (IOException e) {
                        request.setResponseData(null);
                    }
                }
                request.setStatus(STATUS.DONE);
                this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request);
                processReoccurring = true;
                break block48;
                {
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                finally {
                    if (processReoccurring && cmd != null && cmd instanceof Reoccurring) {
                        Date current = new Date();
                        Date nextScheduleTime = ((Reoccurring)cmd).getScheduleTime();
                        if (nextScheduleTime != null && nextScheduleTime.after(current)) {
                            String businessKey = (String)ctx.getData("businessKey");
                            RequestInfo requestInfo = new RequestInfo();
                            requestInfo.setCommandName(cmd.getClass().getName());
                            requestInfo.setKey(businessKey);
                            requestInfo.setStatus(STATUS.QUEUED);
                            requestInfo.setTime(nextScheduleTime);
                            requestInfo.setMessage("Rescheduled reoccurring job");
                            requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
                            requestInfo.setOwner((String)ctx.getData("owner"));
                            if (ctx.getData("retries") != null) {
                                requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
                            } else {
                                requestInfo.setRetries(this.retries);
                            }
                            if (ctx != null) {
                                try {
                                    ctx.getData().remove("ClassLoader");
                                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                                    oout.writeObject(ctx);
                                    requestInfo.setRequestData(bout.toByteArray());
                                }
                                catch (IOException e) {
                                    logger.warn("Error serializing context data", (Throwable)e);
                                    requestInfo.setRequestData(null);
                                }
                            }
                            this.executorStoreService.persistRequest((org.kie.api.executor.RequestInfo)requestInfo);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected error while processin executor's job {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ClassLoader getClassLoader(String deploymentId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deploymentId == null) {
            return cl;
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(deploymentId);
        if (manager != null && manager.getEnvironment().getClassLoader() != null) {
            cl = manager.getEnvironment().getClassLoader();
        }
        return cl;
    }

    public void addContextData(String name, Object data) {
        this.contextData.put(name, data);
    }
}

