/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.utilities.svginline;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class SvgInline {
    private static final String PROPERTY_NAME_VIEW = "view";
    private static final String SVG_SUFFIX = ".svg";
    private static final String VIEW_FOLDER = "view";
    private static final String VIEW_PROPERTY_NAME_PATTERN = "\\\"view\\\"\\s*:.*$";
    private static final String VIEW_PROPERTY_VALUE_SUFFIX = ".svg\",";
    private static final String VIEW_FILE_PROPERTY_NAME_PATTERN = "\\\"_view_file\\\"\\s*:.*$";
    private static final String SVG_FILE_SUFFIX = ".svg";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String ssInFile;
    private String ssOutFile;
    private String viewFolder;
    private Map<String, String> mapSVG = new HashMap<String, String>();
    private Map<String, Integer> mapSVGCounts = new HashMap<String, Integer>();

    public SvgInline(String ssInFile, String ssOutFile) throws IOException {
        this.ssInFile = ssInFile;
        this.ssOutFile = ssOutFile;
        this.viewFolder = this.getViewFolderFromSSFile();
    }

    private String getViewFolderFromSSFile() throws IOException {
        File inFile = new File(this.ssInFile);
        return inFile.getParentFile().getParentFile().getCanonicalPath() + File.separator + "view" + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStencilSet() throws IOException {
        StringBuilder stencilSetFileContents = new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(this.ssInFile), "UTF-8");
            String currentLine = "";
            String prevLine = "";
            while (scanner.hasNextLine()) {
                String newLines;
                prevLine = currentLine;
                currentLine = scanner.nextLine();
                String trimmedPrevLine = prevLine.trim();
                String trimmedCurrentLine = currentLine.trim();
                if (trimmedCurrentLine.matches(VIEW_PROPERTY_NAME_PATTERN) && trimmedCurrentLine.endsWith(VIEW_PROPERTY_VALUE_SUFFIX)) {
                    newLines = this.processViewPropertySvgReference(currentLine);
                    stencilSetFileContents.append(newLines);
                    continue;
                }
                if (trimmedPrevLine.matches(VIEW_FILE_PROPERTY_NAME_PATTERN) && trimmedPrevLine.endsWith(VIEW_PROPERTY_VALUE_SUFFIX) && trimmedCurrentLine.matches(VIEW_PROPERTY_NAME_PATTERN)) {
                    newLines = this.processViewFilePropertySvgReference(prevLine, currentLine);
                    stencilSetFileContents.append(newLines);
                    continue;
                }
                stencilSetFileContents.append(currentLine + LINE_SEPARATOR);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.ssOutFile), "UTF-8"));
            out.write(stencilSetFileContents.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.out.println("SVG files referenced more than once:");
        for (Map.Entry<String, Integer> stringIntegerEntry : this.mapSVGCounts.entrySet()) {
            if (stringIntegerEntry.getValue() <= 1) continue;
            System.out.println("\t" + stringIntegerEntry.getKey() + "\t = " + stringIntegerEntry.getValue());
        }
    }

    private String processViewPropertySvgReference(String viewProperty) throws IOException {
        int indexOfColon = viewProperty.indexOf(58);
        if (indexOfColon > -1) {
            int indexOfValueStart = -1;
            int indexOfSQ = viewProperty.indexOf(39, indexOfColon + 1);
            int indexOfDQ = viewProperty.indexOf(34, indexOfColon + 1);
            indexOfValueStart = indexOfSQ > -1 ? indexOfSQ : indexOfDQ;
            if (indexOfValueStart > -1) {
                String svgContents;
                String viewValue = viewProperty.substring(indexOfValueStart + 1);
                int indexOfValueEnd = -1;
                indexOfSQ = viewValue.lastIndexOf(39);
                indexOfDQ = viewValue.lastIndexOf(34);
                indexOfValueEnd = indexOfSQ > -1 ? indexOfSQ : indexOfDQ;
                if (indexOfValueEnd > -1 && (viewValue = viewValue.substring(0, indexOfValueEnd)).endsWith(".svg") && (svgContents = this.getReferencedSvgFileContents(viewValue)) != null) {
                    String ignorableViewProperty = viewProperty.replace("\"view\"", "\"_view_file\"");
                    StringBuilder newViewProperty = new StringBuilder(ignorableViewProperty).append(LINE_SEPARATOR);
                    newViewProperty.append(viewProperty.substring(0, indexOfValueStart));
                    newViewProperty.append("\"").append(svgContents).append("\",").append(LINE_SEPARATOR);
                    return newViewProperty.toString();
                }
            }
        }
        return viewProperty + LINE_SEPARATOR;
    }

    private String processViewFilePropertySvgReference(String viewFileProperty, String viewProperty) throws IOException {
        int indexOfViewFileValueStart = -1;
        int indexOfViewFileColon = viewFileProperty.indexOf(58);
        if (indexOfViewFileColon > -1) {
            int indexOfSQ = viewFileProperty.indexOf(39, indexOfViewFileColon + 1);
            int indexOfDQ = viewFileProperty.indexOf(34, indexOfViewFileColon + 1);
            indexOfViewFileValueStart = indexOfSQ > -1 ? indexOfSQ : indexOfDQ;
        }
        int indexOfViewValueStart = -1;
        int indexOfViewColon = viewProperty.indexOf(58);
        if (indexOfViewColon > -1) {
            int indexOfSQ = viewProperty.indexOf(39, indexOfViewColon + 1);
            int indexOfDQ = viewProperty.indexOf(34, indexOfViewColon + 1);
            indexOfViewValueStart = indexOfSQ > -1 ? indexOfSQ : indexOfDQ;
        }
        if (indexOfViewFileValueStart > -1 && indexOfViewValueStart > -1) {
            String svgContents;
            String viewFileValue = viewFileProperty.substring(indexOfViewFileValueStart + 1);
            int indexOfViewFileValueEnd = -1;
            int indexOfSQ = viewFileValue.lastIndexOf(39);
            int indexOfDQ = viewFileValue.lastIndexOf(34);
            indexOfViewFileValueEnd = indexOfSQ > -1 ? indexOfSQ : indexOfDQ;
            if (indexOfViewFileValueEnd > -1 && (viewFileValue = viewFileValue.substring(0, indexOfViewFileValueEnd)).endsWith(".svg") && (svgContents = this.getReferencedSvgFileContents(viewFileValue)) != null) {
                StringBuilder newViewProperty = new StringBuilder("");
                newViewProperty.append(viewProperty.substring(0, indexOfViewValueStart));
                newViewProperty.append("\"").append(svgContents).append("\",").append(LINE_SEPARATOR);
                return newViewProperty.toString();
            }
        }
        return viewProperty + LINE_SEPARATOR;
    }

    private String getReferencedSvgFileContents(String svgFilename) throws IOException {
        if (this.mapSVG.containsKey(svgFilename)) {
            this.mapSVGCounts.put(svgFilename, this.mapSVGCounts.get(svgFilename) + 1);
            return this.mapSVG.get(svgFilename);
        }
        String svgPath = this.viewFolder + svgFilename;
        File svgFile = new File(svgPath);
        if (svgFile.exists()) {
            String svgFileContents = null;
            svgFileContents = this.readFile(svgPath);
            svgFileContents = svgFileContents.replace('\r', ' ').replace('\n', ' ').replace("\"", "\\\"");
            this.mapSVGCounts.put(svgFilename, 1);
            this.mapSVG.put(svgFilename, svgFileContents);
            return svgFileContents;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws FileNotFoundException {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = new Scanner(new File(pathname), "UTF-8");
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }
}

