/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.designer.client.DesignerView;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisher;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.type.Bpmn2Type;
import org.jbpm.designer.notification.DesignerNotificationEvent;
import org.jbpm.designer.service.DesignerAssetService;
import org.jbpm.designer.service.DesignerContent;
import org.kie.workbench.common.widgets.client.callbacks.CommandBuilder;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.util.URIUtil;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="jbpm.designer", supportedTypes={Bpmn2Type.class})
public class DesignerPresenter
extends KieEditor<Path> {
    @Inject
    DesignerEditorParametersPublisher designerEditorParametersPublisher;
    @Inject
    private Caller<DesignerAssetService> assetService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<VFSService> vfsServices;
    @Inject
    private Caller<DeleteService> deleteService;
    @Inject
    private Caller<CopyService> copyService;
    @Inject
    private Caller<RenameService> renameService;
    @Inject
    private Bpmn2Type resourceType;
    @Inject
    private User user;
    @Inject
    private ActivityDataIOEditor activityDataIOEditor;
    private DesignerView view;
    private Overview overview;

    @Inject
    public DesignerPresenter(DesignerView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.resourceType);
    }

    @OnMayClose
    public boolean canClose() {
        return this.view.canClose();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    protected void makeMenuBar() {
        if (this.canUpdateProject()) {
            this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(new Command(){

                public void execute() {
                    DesignerPresenter.this.saveAction();
                }
            })).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(this.getSaveAndRename()).addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
        }
        this.fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected Command getSaveAndRename() {
        return () -> {
            if (this.isDirty()) {
                this.view.showYesNoCancelPopup(this.getPopupTitle(), this.getMessage(), this.doSaveAndRename(), this.doRename());
            } else {
                this.doRename().execute();
            }
        };
    }

    boolean isDirty() {
        return !this.view.canSaveDesignerModel();
    }

    String getMessage() {
        return DesignerEditorConstants.INSTANCE.ModelEditorConfirmSaveBeforeRename();
    }

    String getPopupTitle() {
        return DesignerEditorConstants.INSTANCE.Information();
    }

    Command doSaveAndRename() {
        return () -> this.save(this.doRename());
    }

    Command doRename() {
        return () -> this.openRenamePopUp(this.versionRecordManager.getPathToLatest());
    }

    @OnClose
    public void onClose() {
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return super.getWidget();
    }

    public void notifyOpenInXMLEditor(@Observes DesignerNotificationEvent event) {
        if (this.user.getIdentifier().equals(event.getUserId()) && event.getNotification() != null && event.getNotification().equals("openinxmleditor")) {
            this.view.askOpenInXMLEditor();
        }
    }

    public void onLockChange(@Observes UpdatedLockStatusEvent updateLockEvent) {
        if (updateLockEvent.getFile() != null && updateLockEvent.getFile().equals(this.versionRecordManager.getCurrentPath())) {
            this.view.raiseEventUpdateLock();
        }
    }

    private native void publishOpenInXMLEditorTab(DesignerPresenter var1);

    private native void publishOpenInTab(DesignerPresenter var1);

    private native void publishSignalOnAssetDelete(DesignerPresenter var1);

    private native void publishSignalOnAssetCopy(DesignerPresenter var1);

    private native void publishSignalOnAssetRename(DesignerPresenter var1);

    private native void publishSignalOnAssetUpdate(DesignerPresenter var1);

    private native void publishClosePlace(DesignerPresenter var1);

    private native void publishIsLatest(DesignerPresenter var1);

    private native void publishShowDataIOEditor(DesignerPresenter var1);

    private native void publishGetAssignmentsViewProperty(DesignerPresenter var1);

    public boolean isLatest() {
        return this.versionRecordManager.isCurrentLatest();
    }

    public void closePlace() {
        if (this.view.getIsReadOnly()) {
            this.placeManager.forceClosePlace(this.place);
        }
    }

    public void assetCopyEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<ObservablePath>(){

            public void callback(final ObservablePath mypath) {
                DesignerPresenter.this.copyPopUpPresenter.show((Path)mypath, (Validator)DesignerPresenter.this.fileNameValidator, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        DesignerPresenter.this.baseView.showLoading();
                        ((CopyService)DesignerPresenter.this.copyService.call(DesignerPresenter.this.getCopySuccessCallback(DesignerPresenter.this.copyPopUpPresenter.getView()), (ErrorCallback)DesignerPresenter.this.getCopyErrorCallback(DesignerPresenter.this.copyPopUpPresenter.getView()))).copy((Path)mypath, details.getNewFileName(), details.getCommitMessage());
                    }
                });
            }
        })).get(URIUtil.encode((String)uri));
    }

    private HasBusyIndicatorDefaultErrorCallback getCopyErrorCallback(final CopyPopUpPresenter.View copyPopupView) {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView){

            public boolean error(Message message, Throwable throwable) {
                copyPopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    public void showDataIOEditor(String taskName, String datainput, String datainputset, String dataoutput, String dataoutputset, String processvars, String assignments, String datatypes, String disallowedpropertynames, String customassignmentproperties, final JavaScriptObject jscallback) {
        final DesignerPresenter dp = this;
        this.activityDataIOEditor.setCallback(new ActivityDataIOEditor.GetDataCallback(){

            @Override
            public void getData(String data) {
                dp.getDataIOEditorData(data, jscallback);
            }
        });
        String inputvars = null;
        boolean hasInputVars = false;
        boolean isSingleInputVar = false;
        if (datainput != null) {
            inputvars = datainput;
            hasInputVars = true;
            isSingleInputVar = true;
        }
        if (datainputset != null) {
            inputvars = datainputset;
            hasInputVars = true;
            isSingleInputVar = false;
        }
        String outputvars = null;
        boolean hasOutputVars = false;
        boolean isSingleOutputVar = false;
        if (dataoutput != null) {
            outputvars = dataoutput;
            hasOutputVars = true;
            isSingleOutputVar = true;
        }
        if (dataoutputset != null) {
            outputvars = dataoutputset;
            hasOutputVars = true;
            isSingleOutputVar = false;
        }
        AssignmentData assignmentData = new AssignmentData(inputvars, outputvars, processvars, assignments, datatypes, disallowedpropertynames, customassignmentproperties);
        assignmentData.setVariableCountsString(hasInputVars, isSingleInputVar, hasOutputVars, isSingleOutputVar);
        this.activityDataIOEditor.setAssignmentData(assignmentData);
        this.activityDataIOEditor.setDisallowedPropertyNames(assignmentData.getDisallowedPropertyNames());
        this.activityDataIOEditor.setInputAssignmentRows(assignmentData.getAssignmentRows(Variable.VariableType.INPUT));
        this.activityDataIOEditor.setOutputAssignmentRows(assignmentData.getAssignmentRows(Variable.VariableType.OUTPUT));
        this.activityDataIOEditor.setDataTypes(assignmentData.getDataTypes(), assignmentData.getDataTypeDisplayNames());
        this.activityDataIOEditor.setProcessVariables(assignmentData.getProcessVariableNames());
        this.activityDataIOEditor.setCustomAssignmentsProperties(assignmentData.getCustomAssignmentProperties());
        this.activityDataIOEditor.configureDialog(taskName, hasInputVars, isSingleInputVar, hasOutputVars, isSingleOutputVar);
        this.activityDataIOEditor.show();
    }

    private native void getDataIOEditorData(String var1, JavaScriptObject var2);

    public String GetAssignmentsViewProperty(String datainput, String datainputset, String dataoutput, String dataoutputset, String processvars, String assignments, String disallowedpropertynames) {
        String inputvars = null;
        boolean hasInputVars = false;
        boolean isSingleInputVar = false;
        if (datainput != null) {
            inputvars = datainput;
            hasInputVars = true;
            isSingleInputVar = true;
        }
        if (datainputset != null) {
            inputvars = datainputset;
            hasInputVars = true;
            isSingleInputVar = false;
        }
        String outputvars = null;
        boolean hasOutputVars = false;
        boolean isSingleOutputVar = false;
        if (dataoutput != null) {
            outputvars = dataoutput;
            hasOutputVars = true;
            isSingleOutputVar = true;
        }
        if (dataoutputset != null) {
            outputvars = dataoutputset;
            hasOutputVars = true;
            isSingleOutputVar = false;
        }
        AssignmentData assignmentData = new AssignmentData(inputvars, outputvars, processvars, assignments, disallowedpropertynames);
        return assignmentData.getVariableCountsString(hasInputVars, isSingleInputVar, hasOutputVars, isSingleOutputVar);
    }

    public void assetRenameEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<ObservablePath>(){

            public void callback(ObservablePath mypath) {
                DesignerPresenter.this.openRenamePopUp(mypath);
            }
        })).get(URIUtil.encode((String)uri));
    }

    void openRenamePopUp(ObservablePath observablePath) {
        CommandWithFileNameAndCommitMessage renameCommand = this.makeRenameCommand();
        this.renamePopUpPresenter.show((Path)observablePath, (Validator)this.fileNameValidator, renameCommand);
    }

    CommandWithFileNameAndCommitMessage makeRenameCommand() {
        return details -> {
            RenamePopUpPresenter.View view = this.renamePopUpPresenter.getView();
            ObservablePath pathToLatest = this.versionRecordManager.getPathToLatest();
            RemoteCallback<Path> onSuccess = this.getRenameSuccessCallback(view);
            HasBusyIndicatorDefaultErrorCallback onError = this.getRenameErrorCallback(view);
            this.baseView.showLoading();
            ((RenameService)this.getRenameService().call(onSuccess, (ErrorCallback)onError)).rename((Path)pathToLatest, details.getNewFileName(), details.getCommitMessage());
        };
    }

    Caller<RenameService> getRenameService() {
        return this.renameService;
    }

    HasBusyIndicatorDefaultErrorCallback getRenameErrorCallback(final RenamePopUpPresenter.View renamePopupView) {
        return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView){

            public boolean error(Message message, Throwable throwable) {
                renamePopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    private void refreshTitle() {
        this.baseView.refreshTitle(this.getTitleText());
    }

    public void assetDeleteEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path mypath) {
                ((DeleteService)DesignerPresenter.this.deleteService.call(DesignerPresenter.this.getDeleteSuccessCallback(mypath), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DesignerPresenter.this.baseView))).delete(mypath, "");
            }
        })).get(URIUtil.encode((String)uri));
    }

    public boolean assetUpdatedEvent() {
        if (this.concurrentUpdateSessionInfo != null) {
            ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentUpdateSessionInfo.getPath(), (User)this.concurrentUpdateSessionInfo.getIdentity(), (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventSave();
                }
            }, (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventSaveCancel();
                }
            }, (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventReload();
                }
            }).show();
            this.concurrentUpdateSessionInfo = null;
            return true;
        }
        return false;
    }

    private RemoteCallback<Void> getDeleteSuccessCallback(final Path path) {
        return new RemoteCallback<Void>(){

            public void callback(Void response) {
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
                DesignerPresenter.this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest(path));
            }
        };
    }

    private RemoteCallback<Path> getCopySuccessCallback(final CopyPopUpPresenter.View copyPopupView) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                copyPopupView.hide();
                DesignerPresenter.this.baseView.hideBusyIndicator();
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCopiedSuccessfully()));
            }
        };
    }

    RemoteCallback<Path> getRenameSuccessCallback(final RenamePopUpPresenter.View renamePopupView) {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                renamePopupView.hide();
                DesignerPresenter.this.baseView.hideBusyIndicator();
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully()));
                DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                DesignerPresenter.this.placeManager.goTo(path);
            }
        };
    }

    public void openInTab(String filename, String uri) {
        PathPlaceRequest placeRequestImpl = new PathPlaceRequest(PathFactory.newPathBasedOn((String)filename, (String)uri, (Path)this.versionRecordManager.getCurrentPath()));
        placeRequestImpl.addParameter("uuid", uri);
        placeRequestImpl.addParameter("profile", "jbpm");
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void openInXMLEditorTab(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path mypath) {
                PathPlaceRequest placeRequestImpl = new PathPlaceRequest(mypath, "GuvnorTextEditor");
                DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                DesignerPresenter.this.placeManager.goTo((PlaceRequest)placeRequestImpl);
            }
        })).get(URIUtil.encode((String)uri));
    }

    private void disableMenus() {
    }

    protected void loadContent() {
        this.publishOpenInTab(this);
        this.publishOpenInXMLEditorTab(this);
        this.publishSignalOnAssetDelete(this);
        this.publishSignalOnAssetCopy(this);
        this.publishSignalOnAssetRename(this);
        this.publishSignalOnAssetUpdate(this);
        this.publishClosePlace(this);
        this.publishShowDataIOEditor(this);
        this.publishGetAssignmentsViewProperty(this);
        this.publishIsLatest(this);
        if (this.versionRecordManager.getCurrentPath() != null) {
            ((DesignerAssetService)this.assetService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(final String editorID) {
                    String url = GWT.getHostPageBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", "");
                    ((DesignerAssetService)DesignerPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

                        public void callback(final Map<String, String> editorParameters) {
                            ((DesignerAssetService)DesignerPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<DesignerContent>(){

                                public void callback(DesignerContent content) {
                                    DesignerPresenter.this.setup(editorParameters, editorID, content.getOverview());
                                }
                            })).loadContent((Path)DesignerPresenter.this.versionRecordManager.getCurrentPath());
                        }
                    }, (ErrorCallback)new CommandDrivenErrorCallback((HasBusyIndicator)DesignerPresenter.this.view, new CommandBuilder().addNoSuchFileException((HasBusyIndicator)DesignerPresenter.this.view, DesignerPresenter.this.menus).addFileSystemNotFoundException((HasBusyIndicator)DesignerPresenter.this.view, DesignerPresenter.this.menus).build()){

                        public boolean error(Message message, Throwable throwable) {
                            DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                            return super.error(message, throwable);
                        }
                    })).getEditorParameters((Path)DesignerPresenter.this.versionRecordManager.getCurrentPath(), editorID, url, DesignerPresenter.this.place);
                }
            })).getEditorID();
        }
    }

    protected void setup(Map<String, String> editorParameters, String editorID, Overview overview) {
        this.overview = overview;
        if (editorParameters != null) {
            this.resetEditorPages(overview);
            editorParameters.put("readonly", Boolean.toString(this.isReadOnly));
            this.designerEditorParametersPublisher.publish(editorParameters);
            this.view.setup(editorID, editorParameters);
        }
    }

    protected void save() {
        ObservablePath latestPath = this.versionRecordManager.getPathToLatest();
        ((DesignerAssetService)this.assetService.call(aVoid -> this.view.raiseEventCheckSave(latestPath.toURI()))).updateMetadata((Path)latestPath, this.overview.getMetadata());
    }

    protected void save(Command onSuccess) {
        ObservablePath latestPath = this.versionRecordManager.getPathToLatest();
        ((DesignerAssetService)this.assetService.call(aVoid -> {
            this.view.raiseEventUpdate();
            onSuccess.execute();
        })).updateMetadata((Path)latestPath, this.overview.getMetadata());
    }

    public void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.view.raiseEventReload();
    }

    public void setVersionRecordManager(VersionRecordManager versionRecordManager) {
        this.versionRecordManager = versionRecordManager;
    }
}

