/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.gwt.HTMLPanel;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.type.Bpmn2Type;
import org.jbpm.designer.service.DesignerAssetService;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewCaseDefinitionHandler
extends DefaultNewResourceHandler {
    @Inject
    private Caller<DesignerAssetService> designerAssetService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Bpmn2Type resourceType;
    private TextBox caseIdPrefixTextBox = new TextBox();

    public String getDescription() {
        return DesignerEditorConstants.INSTANCE.CaseDefinition();
    }

    public IsWidget getIcon() {
        return null;
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(Pair.newPair((Object)"CaseIdPrefixLabel", (Object)new HTMLPanel(DesignerEditorConstants.INSTANCE.CaseIdPrefix())));
        this.extensions.add(Pair.newPair((Object)"CaseIdPrefixTextBox", (Object)this.caseIdPrefixTextBox));
    }

    public void create(Package pkg, String baseFileName, final NewResourcePresenter presenter) {
        String caseIdPrefix = this.caseIdPrefixTextBox.getValue();
        this.caseIdPrefixTextBox.clear();
        ((DesignerAssetService)this.designerAssetService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path path) {
                presenter.complete();
                NewCaseDefinitionHandler.this.notifySuccess();
                PathPlaceRequest place = new PathPlaceRequest(path);
                NewCaseDefinitionHandler.this.placeManager.goTo((PlaceRequest)place);
            }
        }, (ErrorCallback)new DefaultErrorCallback())).createCaseDefinition(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), caseIdPrefix);
    }

    public void acceptContext(final Callback<Boolean, Void> callback) {
        if (this.context == null) {
            callback.onSuccess((Object)false);
        } else if (this.context.getActiveProject() != null) {
            ((DesignerAssetService)this.designerAssetService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                public void callback(Boolean isCaseProject) {
                    callback.onSuccess((Object)isCaseProject);
                }
            }, (ErrorCallback)new DefaultErrorCallback())).isCaseProject(this.context.getActiveProject().getRootPath());
        } else {
            callback.onSuccess((Object)false);
        }
    }
}

