/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractValidatingTextBox
extends TextBox {
    @Inject
    private Event<NotificationEvent> notification;

    public AbstractValidatingTextBox() {
        this.setup();
    }

    protected void setup() {
        final AbstractValidatingTextBox me = this;
        this.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                int keyCode = AbstractValidatingTextBox.this.getKeyCodeFromKeyPressEvent(event);
                if (event.isControlKeyDown()) {
                    return;
                }
                if (!(event.isShiftKeyDown() || keyCode != 8 && keyCode != 46 && keyCode != 37 && keyCode != 39 && keyCode != 9 && keyCode != 36 && keyCode != 35)) {
                    return;
                }
                char charCode = event.getCharCode();
                String oldValue = me.getValue();
                String newValue = oldValue.substring(0, me.getCursorPos());
                newValue = newValue + (char)charCode;
                String validationError = AbstractValidatingTextBox.this.isValidValue(newValue = newValue + oldValue.substring(me.getCursorPos() + me.getSelectionLength()), false);
                if (validationError != null) {
                    event.preventDefault();
                    AbstractValidatingTextBox.this.fireValidationError(validationError);
                }
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                String value = me.getText();
                String validationError = AbstractValidatingTextBox.this.isValidValue(value, true);
                if (validationError != null) {
                    AbstractValidatingTextBox.this.fireValidationError(validationError);
                    String validValue = AbstractValidatingTextBox.this.makeValidValue(value);
                    me.setValue((Object)validValue);
                    ValueChangeEvent.fire((HasValueChangeHandlers)AbstractValidatingTextBox.this, (Object)validValue);
                }
            }
        });
    }

    public abstract String isValidValue(String var1, boolean var2);

    protected abstract String makeValidValue(String var1);

    protected void fireValidationError(String validationError) {
        this.notification.fire((Object)new NotificationEvent(validationError, NotificationEvent.NotificationType.ERROR));
    }

    protected int getKeyCodeFromKeyPressEvent(KeyPressEvent event) {
        return event.getNativeEvent().getKeyCode();
    }
}

