/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.designer.client.shared.util.StringUtils;

public class ListBoxValues {
    protected List<String> acceptableValuesWithCustomValues = new ArrayList<String>();
    protected List<String> acceptableValuesWithoutCustomValues = new ArrayList<String>();
    protected List<String> customValues = new ArrayList<String>();
    protected Map<String, String> mapDisplayValuesToValues = new HashMap<String, String>();
    protected String customPrompt;
    protected String editPrefix;
    public static final String EDIT_SUFFIX = " ...";
    protected int maxDisplayLength;
    protected static final int DEFAULT_MAX_DISPLAY_LENGTH = -1;
    ValueTester valueTester = null;

    public ListBoxValues(String customPrompt, String editPrefix, ValueTester valueTester, int maxDisplayLength) {
        this.customPrompt = customPrompt;
        this.editPrefix = editPrefix;
        this.valueTester = valueTester;
        this.maxDisplayLength = maxDisplayLength;
    }

    public ListBoxValues(String customPrompt, String editPrefix, ValueTester valueTester) {
        this.customPrompt = customPrompt;
        this.editPrefix = editPrefix;
        this.valueTester = valueTester;
        this.maxDisplayLength = -1;
    }

    public String getEditPrefix() {
        return this.editPrefix;
    }

    public void addValues(List<String> acceptableValues) {
        this.clear();
        if (acceptableValues != null) {
            List<String> displayValues = this.createDisplayValues(acceptableValues);
            this.acceptableValuesWithoutCustomValues.addAll(displayValues);
            this.acceptableValuesWithCustomValues.add("");
            this.acceptableValuesWithCustomValues.add(this.customPrompt);
            this.acceptableValuesWithCustomValues.addAll(displayValues);
        }
    }

    public String addCustomValue(String newValue, String oldValue) {
        if (oldValue != null && !oldValue.isEmpty()) {
            if (this.acceptableValuesWithCustomValues.contains(oldValue)) {
                this.acceptableValuesWithCustomValues.remove(oldValue);
            }
            if (this.customValues.contains(oldValue)) {
                this.customValues.remove(oldValue);
            }
        }
        if (newValue != null && !newValue.isEmpty()) {
            String newDisplayValue = this.addDisplayValue(newValue);
            if (!this.acceptableValuesWithCustomValues.contains(newDisplayValue)) {
                int index = 1;
                if (this.acceptableValuesWithCustomValues.size() < 1) {
                    index = this.acceptableValuesWithCustomValues.size();
                }
                this.acceptableValuesWithCustomValues.add(index, newDisplayValue);
            }
            if (!this.customValues.contains(newDisplayValue)) {
                this.customValues.add(newDisplayValue);
            }
            return newDisplayValue;
        }
        return newValue;
    }

    public List<String> update(String currentValue) {
        String currentEditValuePrompt = this.getEditValuePrompt(this.editPrefix);
        String newEditValuePrompt = this.editPrefix + currentValue + EDIT_SUFFIX;
        if (this.isCustomValue(currentValue)) {
            int editPromptIndex;
            if (newEditValuePrompt.equals(currentEditValuePrompt)) {
                return this.acceptableValuesWithCustomValues;
            }
            if (currentEditValuePrompt != null) {
                this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
            }
            editPromptIndex = (editPromptIndex = this.acceptableValuesWithCustomValues.indexOf(currentValue)) > -1 ? ++editPromptIndex : (this.acceptableValuesWithCustomValues.size() > 1 ? 2 : this.acceptableValuesWithCustomValues.size());
            this.acceptableValuesWithCustomValues.add(editPromptIndex, newEditValuePrompt);
        } else if (currentEditValuePrompt != null) {
            this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
        }
        return this.acceptableValuesWithCustomValues;
    }

    public List<String> getAcceptableValuesWithCustomValues() {
        return this.acceptableValuesWithCustomValues;
    }

    public List<String> getAcceptableValuesWithoutCustomValues() {
        return this.acceptableValuesWithoutCustomValues;
    }

    public boolean isCustomValue(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return this.customValues.contains(value);
    }

    protected void clear() {
        this.customValues.clear();
        this.acceptableValuesWithCustomValues.clear();
        this.acceptableValuesWithoutCustomValues.clear();
        this.mapDisplayValuesToValues.clear();
    }

    protected String getEditValuePrompt(String editPrefix) {
        if (this.acceptableValuesWithCustomValues.size() > 0) {
            for (int i = 0; i < this.acceptableValuesWithCustomValues.size(); ++i) {
                String value = this.acceptableValuesWithCustomValues.get(i);
                if (!value.startsWith(editPrefix)) continue;
                return value;
            }
        }
        return null;
    }

    protected List<String> createDisplayValues(List<String> acceptableValues) {
        ArrayList<String> displayValues = new ArrayList<String>();
        for (String value : acceptableValues) {
            if (value == null) continue;
            displayValues.add(this.addDisplayValue(value));
        }
        return displayValues;
    }

    protected String addDisplayValue(String value) {
        if (this.mapDisplayValuesToValues.containsValue(value)) {
            for (Map.Entry<String, String> entry : this.mapDisplayValuesToValues.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        String displayValue = value;
        if (this.maxDisplayLength > 0 && value != null && StringUtils.isQuotedConstant(value) && value.length() > this.maxDisplayLength + 2) {
            String displayValueStart = value.substring(0, this.maxDisplayLength + 1);
            int nextIndex = 0;
            for (String existingDisplayValue : this.mapDisplayValuesToValues.keySet()) {
                if (!existingDisplayValue.startsWith(displayValueStart)) continue;
                if (existingDisplayValue.length() == this.maxDisplayLength + 9) {
                    String sExistingIndex = existingDisplayValue.substring(existingDisplayValue.length() - 4, existingDisplayValue.length() - 2);
                    try {
                        int existingIndex = Integer.parseInt(sExistingIndex);
                        if (nextIndex > existingIndex) continue;
                        nextIndex = existingIndex + 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (nextIndex != 0) continue;
                ++nextIndex;
            }
            if (nextIndex == 0) {
                displayValue = displayValueStart + "...\"";
            } else {
                String sNextIndex = Integer.toString(nextIndex);
                if (nextIndex < 10) {
                    sNextIndex = "0" + sNextIndex;
                }
                displayValue = displayValueStart + "...(" + sNextIndex + ")\"";
            }
        }
        this.mapDisplayValuesToValues.put(displayValue, value);
        return displayValue;
    }

    public String getValueForDisplayValue(String key) {
        if (this.mapDisplayValuesToValues.containsKey(key)) {
            return this.mapDisplayValuesToValues.get(key);
        }
        return key;
    }

    public String getNonCustomValueForUserString(String userValue) {
        if (this.valueTester != null) {
            return this.valueTester.getNonCustomValueForUserString(userValue);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("acceptableValuesWithoutCustomValues:\n");
        for (String value : this.acceptableValuesWithoutCustomValues) {
            sb.append('\t').append(value).append(",\n");
        }
        sb.append('\n');
        sb.append("acceptableValuesWithCustomValues:\n");
        for (String value : this.acceptableValuesWithCustomValues) {
            sb.append('\t').append(value).append(",\n");
        }
        return sb.toString();
    }

    public static interface ValueTester {
        public String getNonCustomValueForUserString(String var1);
    }
}

